<?php
require_once "../domain-config.php";
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Privacidade Digital | CyberNews</title>
    <meta name="description" content="Proteja sua privacidade online com as melhores VPNs, ferramentas de segurança e dicas de anonimato digital.">
    <meta name="robots" content="index,follow">
    <link rel="canonical" href="<?php echo url("privacidade"); ?>">

    <!-- Open Graph -->
    <meta property="og:title" content="Privacidade Digital - CyberNews">
    <meta property="og:description" content="Guias, ferramentas e VPNs para proteger sua privacidade online.">
    <meta property="og:type" content="website">
    <meta property="og:url" content="<?php echo url("privacidade"); ?>">
    <meta property="og:site_name" content="CyberNews">

    <!-- Google Analytics -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-JBDJ3PPN93"></script>
    <script>
      window.dataLayer = window.dataLayer || [];
      function gtag(){dataLayer.push(arguments);}
      gtag("js", new Date());
      gtag("config", "G-JBDJ3PPN93");
    </script>

    <link rel="stylesheet" href="<?php echo asset("styles.css"); ?>">
    <link rel="stylesheet" href="<?php echo asset("css/news-psychedelic.css"); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
</head>
<body class="psychedelic-mode">
    <div id="main-content">
        <header>
            <div class="container">
                <div class="logo">
                    <h1>CyberNews</h1>
                </div>
                <nav>
                    <a href="<?php echo url(""); ?>" class="admin-btn">
                        <i class="fas fa-home"></i> Início
                    </a>
                </nav>
            </div>
        </header>

        <main>
            <section class="hero-section">
                <div class="container">
                    <h1>Privacidade Digital</h1>
                    <p>Proteja sua privacidade online com as melhores ferramentas e dicas de segurança.</p>
                </div>
            </section>

            <section class="content-section">
                <div class="container">
                    <h2>Ferramentas de Privacidade</h2>
                    <div class="tools-grid">
                        <div class="tool-card">
                            <h3>VPNs Recomendadas</h3>
                            <p>Proteja sua conexão e navegue anonimamente.</p>
                        </div>
                        <div class="tool-card">
                            <h3>Navegadores Seguros</h3>
                            <p>Use navegadores que priorizam sua privacidade.</p>
                        </div>
                        <div class="tool-card">
                            <h3>Ferramentas de Anonimato</h3>
                            <p>Mantenha-se anônimo na internet.</p>
                        </div>
                    </div>
                </div>
            </section>
        </main>

        <footer>
            <div class="container">
                <p>&copy; 2024 CyberNews. Todos os direitos reservados.</p>
            </div>
        </footer>
    </div>

    <script src="<?php echo asset("script.js"); ?>" defer></script>
</body>
</html>