<?php
// Configuração de segurança do admin
session_start();

// Configurações de segurança
ini_set('session.cookie_httponly', 1);
ini_set('session.cookie_secure', 1);
ini_set('session.use_strict_mode', 1);

// Credenciais do admin (em produção, usar banco de dados)
$admin_users = [
    'admin' => '$2y$12$SWykjZCfHYlkFUMIvCWa9u0IO2oifXuhDaBGx0LF2tqZzoC10tplm', // senha: password
    'cybersec' => '$2y$12$rtk67A5aC/KfwwJ/ZIik7e/TCieWJPHIkQrvt/IOelyknXA8PpBHK' // senha: cyber123!
];

// Função para verificar login
function verificarLogin($username, $password) {
    global $admin_users;
    
    if (isset($admin_users[$username])) {
        return password_verify($password, $admin_users[$username]);
    }
    return false;
}

// Função para verificar se está logado
function isLoggedIn() {
    return isset($_SESSION['admin_logged']) && $_SESSION['admin_logged'] === true;
}

// Função para fazer logout
function logout() {
    session_destroy();
    header('Location: login.php');
    exit;
}

// Função para proteger páginas admin
function requireLogin() {
    if (!isLoggedIn()) {
        header('Location: login.php');
        exit;
    }
}

// Função para gerar hash de senha (para criar novas senhas)
function generateHash($password) {
    return password_hash($password, PASSWORD_DEFAULT);
}

// Proteção contra ataques de força bruta
function checkBruteForce() {
    if (!isset($_SESSION['login_attempts'])) {
        $_SESSION['login_attempts'] = 0;
        $_SESSION['last_attempt'] = time();
    }
    
    // Reset após 15 minutos
    if (time() - $_SESSION['last_attempt'] > 900) {
        $_SESSION['login_attempts'] = 0;
    }
    
    // Bloquear após 5 tentativas
    if ($_SESSION['login_attempts'] >= 5) {
        $time_left = 900 - (time() - $_SESSION['last_attempt']);
        if ($time_left > 0) {
            die("Muitas tentativas de login. Tente novamente em " . ceil($time_left/60) . " minutos.");
        }
    }
}

// Registrar tentativa de login
function registerLoginAttempt($success = false) {
    if (!$success) {
        $_SESSION['login_attempts']++;
        $_SESSION['last_attempt'] = time();
    } else {
        unset($_SESSION['login_attempts']);
        unset($_SESSION['last_attempt']);
    }
}
?>
