<?php
require_once __DIR__ . '/admin-config.php';
require_once __DIR__ . '/../analytics-setup.php';
requireLogin();

$admin_user = $_SESSION['admin_user'] ?? 'Admin';
$stats = getAccessStats(30); // Últimos 30 dias
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <base href="/acesso_restrito/">
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Analytics - Admin CyberNews</title>
    <link rel="icon" type="image/svg+xml" href="https://protecaonarede.com.br/acesso_restrito/favicon.svg">
    <link href="styles.css" rel="stylesheet">
    <style>
        .admin-panel {
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
            background: #1a1a1a;
            color: #00ff00;
            min-height: 100vh;
        }
        
        .admin-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            border-bottom: 2px solid #00ff00;
            padding-bottom: 20px;
            margin-bottom: 30px;
        }
        
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        
        .stat-card {
            background: #2a2a2a;
            border: 1px solid #00ff00;
            border-radius: 8px;
            padding: 20px;
            text-align: center;
        }
        
        .stat-number {
            font-size: 2.5em;
            color: #00ff00;
            font-weight: bold;
            margin-bottom: 10px;
        }
        
        .stat-label {
            opacity: 0.8;
            font-size: 0.9em;
        }
        
        .analytics-section {
            background: #2a2a2a;
            border: 1px solid #00ff00;
            border-radius: 8px;
            padding: 20px;
            margin-bottom: 20px;
        }
        
        .analytics-section h3 {
            color: #00ff00;
            margin-bottom: 15px;
            border-bottom: 1px solid #333;
            padding-bottom: 10px;
        }
        
        .page-list {
            list-style: none;
            padding: 0;
        }
        
        .page-list li {
            display: flex;
            justify-content: space-between;
            padding: 8px 0;
            border-bottom: 1px solid #333;
        }
        
        .page-list li:last-child {
            border-bottom: none;
        }
        
        .visit-log {
            max-height: 300px;
            overflow-y: auto;
            font-family: monospace;
            font-size: 0.9em;
        }
        
        .visit-entry {
            padding: 5px 0;
            border-bottom: 1px solid #333;
            opacity: 0.8;
        }
        
        .visit-entry:hover {
            opacity: 1;
            background: rgba(0, 255, 0, 0.05);
        }
        
        .btn {
            background: #00ff00;
            color: #000;
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            text-decoration: none;
            font-weight: bold;
            margin-right: 10px;
        }
        
        .btn:hover {
            background: #00cc00;
        }
        
        .btn-secondary {
            background: #666;
            color: white;
        }
        
        .btn-secondary:hover {
            background: #555;
        }
        
        .google-analytics {
            background: rgba(255, 165, 0, 0.1);
            border: 1px solid #ffa500;
            border-radius: 8px;
            padding: 20px;
            margin-bottom: 20px;
            text-align: center;
        }
        
        .google-analytics h3 {
            color: #ffa500;
        }
        
        .setup-instructions {
            background: rgba(0, 255, 255, 0.1);
            border: 1px solid #00ffff;
            border-radius: 5px;
            padding: 15px;
            margin-top: 15px;
            font-size: 0.9em;
        }
    </style>
</head>
<body>
    <div class="admin-panel">
        <div class="admin-header">
            <div>
                <h1>📊 Analytics & Estatísticas</h1>
                <p>Visualização de acessos e comportamento dos visitantes</p>
            </div>
            <div>
                <a href="index.php" class="btn btn-secondary">← Voltar ao Painel</a>
            </div>
        </div>

        <!-- Google Analytics Setup -->
        <div class="google-analytics">
            <h3>🌐 Google Analytics</h3>
            <p>Para ver estatísticas completas do Google Analytics, configure seu ID:</p>
            
            <div class="setup-instructions">
                <strong>📋 Como configurar:</strong><br>
                1. Acesse <a href="https://analytics.google.com" target="_blank" style="color: #00ffff;">Google Analytics</a><br>
                2. Crie uma propriedade para protecaonarede.com.br<br>
                3. Copie o ID (formato: G-XXXXXXXXXX)<br>
                4. Edite o arquivo analytics-setup.php e substitua 'G-XXXXXXXXXX'<br>
                5. O Google Analytics será automaticamente adicionado a todas as páginas
            </div>
        </div>

        <!-- Estatísticas Locais (Últimos 30 dias) -->
        <div class="stats-grid">
            <div class="stat-card">
                <div class="stat-number"><?= $stats['total_visits'] ?></div>
                <div class="stat-label">Total de Visitas</div>
            </div>
            <div class="stat-card">
                <div class="stat-number"><?= $stats['unique_ips'] ?></div>
                <div class="stat-label">IPs Únicos</div>
            </div>
            <div class="stat-card">
                <div class="stat-number"><?= count($stats['top_pages']) ?></div>
                <div class="stat-label">Páginas Acessadas</div>
            </div>
            <div class="stat-card">
                <div class="stat-number"><?= date('d/m') ?></div>
                <div class="stat-label">Última Atualização</div>
            </div>
        </div>

        <!-- Páginas Mais Visitadas -->
        <div class="analytics-section">
            <h3>📈 Páginas Mais Visitadas (30 dias)</h3>
            <?php if (!empty($stats['top_pages'])): ?>
                <ul class="page-list">
                    <?php foreach ($stats['top_pages'] as $page => $visits): ?>
                        <li>
                            <span><?= htmlspecialchars($page) ?></span>
                            <span><strong><?= $visits ?></strong> visitas</span>
                        </li>
                    <?php endforeach; ?>
                </ul>
            <?php else: ?>
                <p style="opacity: 0.7;">Nenhum dado disponível ainda. Os logs começarão a ser coletados automaticamente.</p>
            <?php endif; ?>
        </div>

        <!-- Log de Acessos Recentes -->
        <div class="analytics-section">
            <h3>🕒 Acessos Recentes</h3>
            <div class="visit-log">
                <?php if (!empty($stats['recent_visits'])): ?>
                    <?php foreach ($stats['recent_visits'] as $visit): ?>
                        <div class="visit-entry">
                            <strong><?= $visit['time'] ?></strong> - 
                            IP: <?= htmlspecialchars($visit['ip']) ?> - 
                            Página: <?= htmlspecialchars($visit['page']) ?> - 
                            Origem: <?= htmlspecialchars($visit['referer']) ?>
                        </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <p style="opacity: 0.7;">Nenhum acesso registrado ainda.</p>
                <?php endif; ?>
            </div>
        </div>

        <!-- Informações Técnicas -->
        <div class="analytics-section">
            <h3>🔧 Informações do Sistema</h3>
            <div style="font-family: monospace; font-size: 0.9em;">
                <p><strong>Arquivo de Log:</strong> /admin/logs/access.log</p>
                <p><strong>Coleta Automática:</strong> ✅ Ativa</p>
                <p><strong>Período:</strong> Últimos 30 dias</p>
                <p><strong>Servidor:</strong> <?= $_SERVER['SERVER_NAME'] ?? 'localhost' ?></p>
                <p><strong>PHP:</strong> <?= PHP_VERSION ?></p>
                <p><strong>Timezone:</strong> <?= date_default_timezone_get() ?></p>
            </div>
        </div>

        <div style="text-align: center; margin-top: 40px; opacity: 0.7; font-size: 12px;">
            <p>📊 Analytics em tempo real | Dados coletados automaticamente</p>
            <p>Usuário: <?= htmlspecialchars($admin_user) ?> | Atualizado: <?= date('H:i:s') ?></p>
        </div>
    </div>

    <script>
        // Auto-refresh a cada 30 segundos
        setTimeout(() => {
            location.reload();
        }, 30000);
    </script>
</body>
</html>
