<?php
require_once __DIR__ . '/admin-config.php';
requireLogin();

$admin_user = $_SESSION['admin_user'] ?? 'Admin';

// Processar formulário de configurações
$message = '';
if ($_POST) {
    $message = '✅ Configurações salvas com sucesso!';
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <base href="/acesso_restrito/">
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Configurações - Admin CyberNews</title>
    <link rel="icon" type="image/svg+xml" href="https://protecaonarede.com.br/acesso_restrito/favicon.svg">
    <link href="styles.css" rel="stylesheet">
    <style>
        .admin-panel {
            max-width: 1000px;
            margin: 0 auto;
            padding: 20px;
            background: #1a1a1a;
            color: #00ff00;
            min-height: 100vh;
        }
        
        .admin-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            border-bottom: 2px solid #00ff00;
            padding-bottom: 20px;
            margin-bottom: 30px;
        }
        
        .config-section {
            background: #2a2a2a;
            border: 1px solid #00ff00;
            border-radius: 8px;
            padding: 20px;
            margin-bottom: 20px;
        }
        
        .config-section h3 {
            color: #00ff00;
            margin-bottom: 15px;
            border-bottom: 1px solid #333;
            padding-bottom: 10px;
        }
        
        .form-group {
            margin-bottom: 15px;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
        }
        
        .form-group input, .form-group select, .form-group textarea {
            width: 100%;
            padding: 10px;
            background: #333;
            border: 1px solid #555;
            border-radius: 5px;
            color: #00ff00;
            font-family: inherit;
        }
        
        .form-group input:focus, .form-group select:focus, .form-group textarea:focus {
            outline: none;
            border-color: #00ff00;
            box-shadow: 0 0 5px rgba(0, 255, 0, 0.3);
        }
        
        .btn {
            background: #00ff00;
            color: #000;
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-weight: bold;
            margin-right: 10px;
        }
        
        .btn:hover {
            background: #00cc00;
        }
        
        .btn-secondary {
            background: #666;
            color: white;
        }
        
        .btn-secondary:hover {
            background: #555;
        }
        
        .message {
            background: rgba(0, 255, 0, 0.1);
            border: 1px solid #00ff00;
            color: #00ff00;
            padding: 10px;
            border-radius: 5px;
            margin-bottom: 20px;
        }
        
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
            margin-bottom: 20px;
        }
        
        .stat-item {
            background: #333;
            padding: 10px;
            border-radius: 5px;
            text-align: center;
        }
        
        .stat-value {
            font-size: 1.5em;
            color: #00ff00;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <div class="admin-panel">
        <div class="admin-header">
            <div>
                <h1>⚙️ Configurações do Sistema</h1>
                <p>Gerenciar configurações do CyberNews</p>
            </div>
            <div>
                <a href="index.php" class="btn btn-secondary">← Voltar ao Painel</a>
            </div>
        </div>

        <?php if ($message): ?>
            <div class="message"><?= $message ?></div>
        <?php endif; ?>

        <form method="POST">
            <div class="config-section">
                <h3>🌐 Configurações Gerais</h3>
                
                <div class="form-group">
                    <label>Nome do Site:</label>
                    <input type="text" name="site_name" value="CyberNews - Proteção na Rede">
                </div>
                
                <div class="form-group">
                    <label>Descrição:</label>
                    <textarea name="site_description" rows="3">Agregador de notícias de segurança da informação e cibersegurança</textarea>
                </div>
                
                <div class="form-group">
                    <label>Email do Administrador:</label>
                    <input type="email" name="admin_email" value="admin@protecaonarede.com.br">
                </div>
                
                <div class="form-group">
                    <label>Fuso Horário:</label>
                    <select name="timezone">
                        <option value="America/Sao_Paulo" selected>São Paulo (GMT-3)</option>
                        <option value="UTC">UTC (GMT+0)</option>
                    </select>
                </div>
            </div>

            <div class="config-section">
                <h3>🔒 Configurações de Segurança</h3>
                
                <div class="form-group">
                    <label>Tempo de Sessão (minutos):</label>
                    <input type="number" name="session_timeout" value="30" min="5" max="480">
                </div>
                
                <div class="form-group">
                    <label>Máximo de Tentativas de Login:</label>
                    <input type="number" name="max_login_attempts" value="5" min="3" max="10">
                </div>
                
                <div class="form-group">
                    <label>Tempo de Bloqueio (minutos):</label>
                    <input type="number" name="lockout_time" value="15" min="5" max="60">
                </div>
                
                <div class="form-group">
                    <label>
                        <input type="checkbox" name="enable_2fa" style="width: auto; margin-right: 10px;">
                        Ativar Autenticação de Dois Fatores (Em desenvolvimento)
                    </label>
                </div>
            </div>

            <div class="config-section">
                <h3>📊 Estatísticas do Sistema (Tempo Real)</h3>
                
                <div class="stats-grid">
                    <div class="stat-item">
                        <div class="stat-value"><?= count(glob(__DIR__ . '/../*.php')) ?></div>
                        <div>Páginas PHP</div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-value"><?= date('H:i') ?></div>
                        <div>Hora Atual</div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-value"><?= date('d/m/Y') ?></div>
                        <div>Data</div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-value">🔒</div>
                        <div>Sistema Seguro</div>
                    </div>
                </div>
                
                <div class="form-group">
                    <label>
                        <input type="checkbox" name="enable_analytics" style="width: auto; margin-right: 10px;" checked>
                        Ativar Coleta de Estatísticas Reais
                    </label>
                </div>
                
                <div class="form-group">
                    <label>
                        <input type="checkbox" name="enable_logs" style="width: auto; margin-right: 10px;" checked>
                        Ativar Logs de Acesso
                    </label>
                </div>
            </div>

            <div class="config-section">
                <h3>🎨 Configurações de Aparência</h3>
                
                <div class="form-group">
                    <label>Tema:</label>
                    <select name="theme">
                        <option value="dark-green" selected>Verde Hacker (Atual)</option>
                        <option value="dark-blue">Azul Cyber</option>
                        <option value="matrix">Matrix</option>
                    </select>
                </div>
                
                <div class="form-group">
                    <label>Mostrar Preloader:</label>
                    <select name="show_preloader">
                        <option value="1" selected>Sim</option>
                        <option value="0">Não</option>
                    </select>
                </div>
            </div>

            <div style="text-align: center; margin-top: 30px;">
                <button type="submit" class="btn">💾 Salvar Configurações</button>
                <a href="index.php" class="btn btn-secondary">❌ Cancelar</a>
            </div>
        </form>

        <div style="text-align: center; margin-top: 40px; opacity: 0.7; font-size: 12px;">
            <p>⚠️ Algumas funcionalidades estão em desenvolvimento</p>
            <p>Usuário: <?= htmlspecialchars($admin_user) ?> | Versão: 2.0</p>
        </div>
    </div>
</body>
</html>
