<?php
require_once __DIR__ . '/admin-config.php';

// Verificar se está logado
requireLogin();

// Processar logout
if (isset($_GET['logout'])) {
    logout();
}

$admin_user = $_SESSION['admin_user'] ?? 'Admin';
$login_time = date('H:i:s', $_SESSION['login_time'] ?? time());
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <base href="/acesso_restrito/">
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Painel Admin - CyberNews</title>
    <link rel="icon" type="image/svg+xml" href="https://protecaonarede.com.br/acesso_restrito/favicon.svg">
    <link href="styles.css" rel="stylesheet">
    <style>
        .admin-panel {
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
            background: #1a1a1a;
            color: #00ff00;
            min-height: 100vh;
        }
        
        .admin-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            border-bottom: 2px solid #00ff00;
            padding-bottom: 20px;
            margin-bottom: 30px;
            flex-wrap: wrap;
        }
        
        .admin-header h1 {
            color: #00ff00;
            text-shadow: 0 0 10px #00ff00;
        }
        
        .admin-info {
            text-align: right;
            opacity: 0.8;
        }
        
        .admin-info .user-info {
            margin-bottom: 10px;
        }
        
        .logout-btn {
            background: #ff4444;
            color: white;
            padding: 8px 15px;
            border: none;
            border-radius: 5px;
            text-decoration: none;
            font-size: 12px;
            transition: all 0.3s;
        }
        
        .logout-btn:hover {
            background: #cc3333;
            transform: scale(1.05);
        }
        
        .admin-stats {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
            margin-bottom: 30px;
        }
        
        .stat-card {
            background: #2a2a2a;
            border: 1px solid #00ff00;
            border-radius: 8px;
            padding: 15px;
            text-align: center;
        }
        
        .stat-number {
            font-size: 2em;
            color: #00ff00;
            font-weight: bold;
        }
        
        .admin-cards {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 20px;
        }
        
        .admin-card {
            background: #2a2a2a;
            border: 1px solid #00ff00;
            border-radius: 8px;
            padding: 20px;
            text-align: center;
            transition: transform 0.3s;
            position: relative;
        }
        
        .admin-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 5px 20px rgba(0, 255, 0, 0.3);
        }
        
        .admin-card h3 {
            color: #00ff00;
            margin-bottom: 15px;
        }
        
        .admin-btn {
            background: #00ff00;
            color: #000;
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            text-decoration: none;
            display: inline-block;
            margin: 5px;
            font-weight: bold;
            transition: all 0.3s;
        }
        
        .admin-btn:hover {
            background: #00cc00;
            transform: scale(1.05);
        }
        
        .back-btn {
            position: fixed;
            top: 20px;
            left: 20px;
            background: #666;
            color: white;
        }
        
        .back-btn:hover {
            background: #555;
        }
        
        .security-indicator {
            position: fixed;
            bottom: 20px;
            right: 20px;
            background: rgba(0, 255, 0, 0.1);
            border: 1px solid #00ff00;
            border-radius: 50px;
            padding: 10px 15px;
            font-size: 12px;
            opacity: 0.8;
        }
        
        .status-online {
            display: inline-block;
            width: 8px;
            height: 8px;
            background: #00ff00;
            border-radius: 50%;
            margin-right: 5px;
            animation: pulse 2s infinite;
        }
        
        @keyframes pulse {
            0% { opacity: 1; }
            50% { opacity: 0.5; }
            100% { opacity: 1; }
        }
        
        .coming-soon {
            opacity: 0.6;
            font-style: italic;
        }
        
        .admin-card.disabled {
            opacity: 0.5;
            pointer-events: none;
        }
    </style>
</head>
<body>
    <div class="admin-panel">
        <a href="../" class="admin-btn back-btn">← Site</a>
        
        <div class="admin-header">
            <div>
                <h1>🛡️ Painel Administrativo</h1>
                <p>Gerenciamento Seguro do CyberNews</p>
            </div>
            <div class="admin-info">
                <div class="user-info">
                    👤 <strong><?= htmlspecialchars($admin_user) ?></strong><br>
                    🕒 Login: <?= $login_time ?>
                </div>
                <a href="?logout=1" class="logout-btn" onclick="return confirm('Deseja sair do painel?')">
                    🚪 Logout
                </a>
            </div>
        </div>

        <div class="admin-stats">
            <div class="stat-card">
                <div class="stat-number">127</div>
                <div>Notícias Publicadas</div>
            </div>
            <div class="stat-card">
                <div class="stat-number">1.2K</div>
                <div>Visitantes Hoje</div>
            </div>
            <div class="stat-card">
                <div class="stat-number">98%</div>
                <div>Uptime</div>
            </div>
            <div class="stat-card">
                <div class="stat-number">🔒</div>
                <div>Sistema Seguro</div>
            </div>
        </div>

        <div class="admin-cards">
            <div class="admin-card">
                <h3>📰 Gerenciar Notícias</h3>
                <p>Adicionar, editar e remover notícias de segurança</p>
                <a href="noticias.php" class="admin-btn">Gerenciar</a>
                <div class="coming-soon">Em desenvolvimento</div>
            </div>

            <div class="admin-card">
                <h3>🔒 Segurança & Logs</h3>
                <p>Monitorar logs de acesso e configurar segurança</p>
                <a href="security.php" class="admin-btn">Acessar</a>
                <div class="coming-soon">Em desenvolvimento</div>
            </div>

            <div class="admin-card">
                <h3>🛒 E-commerce</h3>
                <p>Gerenciar produtos, pedidos e vendas</p>
                <a href="loja.php" class="admin-btn">Loja Admin</a>
                <div class="coming-soon">Em desenvolvimento</div>
            </div>

            <div class="admin-card">
                <h3>👥 Usuários</h3>
                <p>Gerenciar usuários e permissões do sistema</p>
                <a href="users.php" class="admin-btn">Usuários</a>
                <div class="coming-soon">Em desenvolvimento</div>
            </div>

            <div class="admin-card">
                <h3>📊 Analytics</h3>
                <p>Estatísticas detalhadas e relatórios</p>
                <a href="analytics.php" class="admin-btn">Ver Dados</a>
                <div class="coming-soon">Em desenvolvimento</div>
            </div>

            <div class="admin-card">
                <h3>⚙️ Configurações</h3>
                <p>Configurações gerais do sistema e banco</p>
                <a href="config.php" class="admin-btn">Configurar</a>
                <div class="coming-soon">Em desenvolvimento</div>
            </div>
        </div>

        <div style="text-align: center; margin-top: 40px; opacity: 0.7;">
            <p>🔐 Área Administrativa Segura</p>
            <p>Versão 2.0 - Autenticação Ativa - <?= date('Y') ?> CyberNews</p>
        </div>
    </div>

    <div class="security-indicator">
        <span class="status-online"></span>
        Sessão Segura
    </div>

    <script src="js/performance.js"></script>
    <script>
        // Auto-logout após inatividade (30 minutos)
        let inactivityTimer;
        
        function resetTimer() {
            clearTimeout(inactivityTimer);
            inactivityTimer = setTimeout(() => {
                if (confirm('Sessão expirada por inatividade. Deseja renovar?')) {
                    location.reload();
                } else {
                    location.href = '?logout=1';
                }
            }, 30 * 60 * 1000); // 30 minutos
        }
        
        // Eventos para detectar atividade
        ['mousedown', 'mousemove', 'keypress', 'scroll', 'touchstart'].forEach(event => {
            document.addEventListener(event, resetTimer, true);
        });
        
        resetTimer(); // Iniciar timer
    </script>
</body>
</html>
