<?php
require_once __DIR__ . '/admin-config.php';

// Se já está logado, redirecionar para o painel
if (isLoggedIn()) {
    header('Location: index.php');
    exit;
}

$error = '';

// Processar login
if ($_POST) {
    checkBruteForce();
    
    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';
    
    if (empty($username) || empty($password)) {
        $error = 'Usuário e senha são obrigatórios.';
    } else {
        if (verificarLogin($username, $password)) {
            $_SESSION['admin_logged'] = true;
            $_SESSION['admin_user'] = $username;
            $_SESSION['login_time'] = time();
            
            registerLoginAttempt(true);
            header('Location: index.php');
            exit;
        } else {
            $error = 'Usuário ou senha incorretos.';
            registerLoginAttempt(false);
        }
    }
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <base href="/acesso_restrito/">
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login Admin - CyberNews</title>
    <link rel="icon" type="image/svg+xml" href="https://protecaonarede.com.br/acesso_restrito/favicon.svg">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            background: linear-gradient(135deg, #0a0a0a 0%, #1a1a1a 100%);
            color: #00ff00;
            font-family: 'Courier New', monospace;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .login-container {
            background: rgba(26, 26, 26, 0.95);
            border: 2px solid #00ff00;
            border-radius: 10px;
            padding: 40px;
            box-shadow: 0 0 50px rgba(0, 255, 0, 0.3);
            max-width: 400px;
            width: 100%;
            animation: glow 2s ease-in-out infinite alternate;
        }
        
        @keyframes glow {
            from { box-shadow: 0 0 20px rgba(0, 255, 0, 0.3); }
            to { box-shadow: 0 0 30px rgba(0, 255, 0, 0.6); }
        }
        
        .login-header {
            text-align: center;
            margin-bottom: 30px;
        }
        
        .login-header h1 {
            font-size: 2em;
            margin-bottom: 10px;
            text-shadow: 0 0 10px #00ff00;
        }
        
        .login-header p {
            opacity: 0.8;
            font-size: 0.9em;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
        }
        
        .form-group input {
            width: 100%;
            padding: 12px;
            background: #2a2a2a;
            border: 1px solid #00ff00;
            border-radius: 5px;
            color: #00ff00;
            font-family: inherit;
            font-size: 14px;
            transition: all 0.3s;
        }
        
        .form-group input:focus {
            outline: none;
            border-color: #00cc00;
            box-shadow: 0 0 10px rgba(0, 255, 0, 0.3);
        }
        
        .login-btn {
            width: 100%;
            padding: 15px;
            background: #00ff00;
            color: #000;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            font-weight: bold;
            cursor: pointer;
            transition: all 0.3s;
            text-transform: uppercase;
        }
        
        .login-btn:hover {
            background: #00cc00;
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0, 255, 0, 0.4);
        }
        
        .error {
            background: rgba(255, 0, 0, 0.1);
            border: 1px solid #ff0000;
            color: #ff6666;
            padding: 10px;
            border-radius: 5px;
            margin-bottom: 20px;
            text-align: center;
        }
        
        .back-link {
            text-align: center;
            margin-top: 20px;
        }
        
        .back-link a {
            color: #00ff00;
            text-decoration: none;
            opacity: 0.8;
            transition: opacity 0.3s;
        }
        
        .back-link a:hover {
            opacity: 1;
        }
        
        .security-info {
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #333;
            font-size: 0.8em;
            opacity: 0.6;
            text-align: center;
        }
        
        .matrix-bg {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: -1;
            opacity: 0.1;
            pointer-events: none;
        }
    </style>
</head>
<body>
    <div class="matrix-bg"></div>
    
    <div class="login-container">
        <div class="login-header">
            <h1>🛡️ ADMIN LOGIN</h1>
            <p>Área Restrita - Acesso Autorizado</p>
        </div>
        
        <?php if ($error): ?>
            <div class="error">⚠️ <?= htmlspecialchars($error) ?></div>
        <?php endif; ?>
        
        <form method="POST" action="">
            <div class="form-group">
                <label for="username">👤 Usuário:</label>
                <input type="text" id="username" name="username" required autocomplete="username" value="<?= htmlspecialchars($_POST['username'] ?? '') ?>">
            </div>
            
            <div class="form-group">
                <label for="password">🔐 Senha:</label>
                <input type="password" id="password" name="password" required autocomplete="current-password">
            </div>
            
            <button type="submit" class="login-btn">🚀 Acessar Painel</button>
        </form>
        
        <div class="back-link">
            <a href="../">← Voltar ao Site</a>
        </div>
        
        <div class="security-info">
            🔒 Conexão Segura | Tentativas limitadas<br>
            Sistema protegido contra força bruta
        </div>
    </div>
    
    <script>
        // Efeito Matrix no fundo
        const canvas = document.createElement('canvas');
        const ctx = canvas.getContext('2d');
        document.querySelector('.matrix-bg').appendChild(canvas);
        
        canvas.width = window.innerWidth;
        canvas.height = window.innerHeight;
        
        const matrix = "ABCDEFGHIJKLMNOPQRSTUVWXYZ123456789@#$%^&*()*&^%+-/~{[|`]}";
        const matrixArray = matrix.split("");
        
        const fontSize = 10;
        const columns = canvas.width / fontSize;
        const drops = [];
        
        for(let x = 0; x < columns; x++) {
            drops[x] = 1;
        }
        
        function draw() {
            ctx.fillStyle = 'rgba(0, 0, 0, 0.04)';
            ctx.fillRect(0, 0, canvas.width, canvas.height);
            
            ctx.fillStyle = '#00ff00';
            ctx.font = fontSize + 'px monospace';
            
            for(let i = 0; i < drops.length; i++) {
                const text = matrixArray[Math.floor(Math.random() * matrixArray.length)];
                ctx.fillText(text, i * fontSize, drops[i] * fontSize);
                
                if(drops[i] * fontSize > canvas.height && Math.random() > 0.975) {
                    drops[i] = 0;
                }
                drops[i]++;
            }
        }
        
        setInterval(draw, 35);
        
        // Focus no primeiro campo
        document.getElementById('username').focus();
    </script>
</body>
</html>
