<?php
/**
 * CONFIGURAÇÃO OTIMIZADA PARA PRODUÇÃO
 * CyberNews - Performance First
 */

// Configurações de performance
ini_set('memory_limit', '128M');
ini_set('max_execution_time', '30');

// Headers de cache e compressão
function setOptimalHeaders() {
    // Cache para recursos estáticos
    if (preg_match('/\.(css|js|png|jpg|jpeg|gif|webp|svg|woff|woff2|ttf)$/i', $_SERVER['REQUEST_URI'])) {
        header('Cache-Control: public, max-age=31536000'); // 1 ano
        header('Expires: ' . gmdate('D, d M Y H:i:s \G\M\T', time() + 31536000));
    }
    
    // Cache para páginas HTML
    if (preg_match('/\.(php|html)$/i', $_SERVER['REQUEST_URI']) || !pathinfo($_SERVER['REQUEST_URI'], PATHINFO_EXTENSION)) {
        header('Cache-Control: public, max-age=3600'); // 1 hora
    }
    
    // Compressão GZIP
    if (!ob_get_level() && extension_loaded('zlib')) {
        ob_start('ob_gzhandler');
    }
    
    // Headers de segurança essenciais
    header('X-Content-Type-Options: nosniff');
    header('X-Frame-Options: DENY');
    header('X-XSS-Protection: 1; mode=block');
    header('Referrer-Policy: strict-origin-when-cross-origin');
}

// Minificação inline de HTML
function minifyHTML($html) {
    // Remove comentários HTML
    $html = preg_replace('/<!--(?!<!)[^\[>].*?-->/s', '', $html);
    
    // Remove espaços extras entre tags
    $html = preg_replace('/>\s+</', '><', $html);
    
    // Remove quebras de linha desnecessárias
    $html = preg_replace('/\s+/', ' ', $html);
    
    return trim($html);
}

// CSS crítico inline
function getCriticalCSS() {
    $critical = file_get_contents(__DIR__ . '/css/critical.css');
    return $critical ? $critical : '';
}

// Detectar dispositivo para otimizações
function isMobile() {
    return preg_match('/Mobile|Android|iPhone|iPad/', $_SERVER['HTTP_USER_AGENT'] ?? '');
}

// Configurar timezone
date_default_timezone_set('America/Sao_Paulo');

// Aplicar headers otimizados
setOptimalHeaders();

// Configurações globais
define('SITE_NAME', 'CyberNews');
define('SITE_VERSION', '1.2');
define('IS_MOBILE', isMobile());
define('PERFORMANCE_MODE', true);
?>
