<?php
// Script para extrair e mover as páginas

echo "🚀 Iniciando extração das páginas...\n";

// Extrair o arquivo
if (file_exists('pages.tar.gz')) {
    $command = 'tar -xzf pages.tar.gz -C acesso_restrito/';
    exec($command, $output, $return_var);
    
    if ($return_var === 0) {
        echo "✅ Páginas extraídas com sucesso!\n";
        
        // Remover arquivo temporário
        unlink('pages.tar.gz');
        echo "🗑️ Arquivo temporário removido.\n";
        
        // Listar arquivos criados
        $files = glob('acesso_restrito/*.php');
        foreach ($files as $file) {
            echo "📄 Criado: $file\n";
        }
        
        echo "\n🎉 Processo concluído com sucesso!\n";
    } else {
        echo "❌ Erro ao extrair páginas.\n";
    }
} else {
    echo "❌ Arquivo pages.tar.gz não encontrado.\n";
}
?>
