<?php
// Configuração otimizada
require_once 'config.php';

// Verificar se está sendo acessado via /acesso_restrito/ e incluir domain-config
$isAcessoRestrito = strpos($_SERVER['REQUEST_URI'], '/acesso_restrito/') !== false;
if ($isAcessoRestrito) {
    require_once 'domain-config.php';
}

// Aplicar otimizações básicas
if (extension_loaded('zlib') && !ob_get_level()) {
    ob_start('ob_gzhandler');
}

// Detectar dispositivo móvel
function isMobileDevice() {
    $userAgent = $_SERVER['HTTP_USER_AGENT'] ?? '';
    return preg_match('/Mobile|Android|iPhone|iPad/', $userAgent);
}
$isMobile = isMobileDevice();

// Dados SEO básicos
$seoData = [
    'title' => 'CyberNews - Notícias de Cibersegurança e Proteção Digital',
    'description' => 'Portal de notícias especializado em cibersegurança, proteção digital, vulnerabilidades e malware.',
    'keywords' => 'cibersegurança, segurança digital, vulnerabilidades, malware, proteção',
    'og_image' => '/assets/cybernews-logo.jpg'
];
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $seoData['title']; ?></title>
    <meta name="description" content="<?php echo $seoData['description']; ?>">
    <meta name="keywords" content="<?php echo $seoData['keywords']; ?>">
    <meta name="robots" content="index,follow">
    <link rel="canonical" href="https://protecaonarede.com.br/">
    
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="https://protecaonarede.com.br/">
    <meta property="og:title" content="<?php echo $seoData['title']; ?>">
    <meta property="og:description" content="<?php echo $seoData['description']; ?>">
    <meta property="og:image" content="https://protecaonarede.com.br<?php echo $seoData['og_image']; ?>">
    <meta property="og:site_name" content="CyberNews">
    
    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="https://protecaonarede.com.br/">
    <meta property="twitter:title" content="<?php echo $seoData['title']; ?>">
    <meta property="twitter:description" content="<?php echo $seoData['description']; ?>">
    <meta property="twitter:image" content="https://protecaonarede.com.br<?php echo $seoData['og_image']; ?>">
    
    <link rel="alternate" type="application/rss+xml" title="RSS Feed" href="rss.php">
    <!-- CSS crítico inline -->
    <style><?= getCriticalCSS() ?></style>
    
    <!-- Preload recursos importantes -->
    <link rel="preload" href="<?php echo $isAcessoRestrito ? asset('styles.css') : 'styles.css'; ?>" as="style">
    <link rel="preload" href="<?php echo $isAcessoRestrito ? asset('script.js') : 'script.js'; ?>" as="script">
    
    <!-- CSS não crítico carregado de forma assíncrona -->
    <link rel="stylesheet" href="<?php echo $isAcessoRestrito ? asset('styles.css') : 'styles.css'; ?>" media="print" onload="this.media='all'">
    <link rel="stylesheet" href="<?php echo $isAcessoRestrito ? asset('css/news-psychedelic.css') : 'css/news-psychedelic.css'; ?>" media="print" onload="this.media='all'">
    
    <!-- Font Awesome otimizado -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" media="print" onload="this.media='all'">
    
    <!-- Fonts otimizadas -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
    
    <!-- Google Analytics -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-JBDJ3PPN93"></script>
    <script>
      window.dataLayer = window.dataLayer || [];
      function gtag(){dataLayer.push(arguments);}
      gtag('js', new Date());
      gtag('config', 'G-JBDJ3PPN93');
    </script>
    
    <!-- Estilos críticos inline -->
    <style>
    .news-card .news-image { height: <?php echo $isMobile ? '150px' : '200px'; ?>; }
    .news-card .news-image img { width: 100%; height: 100%; object-fit: cover; }
    .news-card .image-placeholder { display: flex; }
    <?php if ($isMobile): ?>
    <?php echo getMobileCriticalCSS(); ?>
    <?php endif; ?>
    </style>
</head>
<body class="psychedelic-mode">
    <!-- Botão Voltar ao Topo -->
    <div class="back-to-top">
        <i class="fas fa-arrow-up"></i>
    </div>


    <!-- Menu Lateral Alucinado -->
    <div class="psychedelic-menu-container">
        <div class="menu-toggle">
            <div class="hamburger">
                <span></span>
                <span></span>
                <span></span>
            </div>
        </div>
        
        <nav class="side-menu">
            <div class="menu-background">
                <div class="liquid-shape"></div>
                <div class="fractal-pattern"></div>
                <div class="glow-particles"></div>
            </div>
            
            <div class="menu-content">
                <div class="menu-header">
                    <div class="menu-logo">
                        <h2>CyberNews</h2>
                    </div>
                </div>
                
                <ul class="menu-items">
                    <li class="menu-item active">
                        <a href="#" class="menu-link">
                            <i class="fas fa-home"></i>
                            <span>Início</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                    <li class="menu-item">
                        <a href="<?php echo url('noticias'); ?>" class="menu-link">
                            <i class="fas fa-newspaper"></i>
                            <span>Notícias</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                    <li class="menu-item">
                        <a href="<?php echo url('seguranca'); ?>" class="menu-link">
                            <i class="fas fa-lock"></i>
                            <span>Segurança</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                    <li class="menu-item">
                        <a href="<?php echo url('vulnerabilidades'); ?>" class="menu-link">
                            <i class="fas fa-bug"></i>
                            <span>Vulnerabilidades</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                    <li class="menu-item">
                        <a href="<?php echo url('malware'); ?>" class="menu-link">
                            <i class="fas fa-virus"></i>
                            <span>Malware</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                    <li class="menu-item">
                        <a href="<?php echo url('privacidade'); ?>" class="menu-link">
                            <i class="fas fa-user-secret"></i>
                            <span>Privacidade</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                    <li class="menu-item">
                        <a href="<?php echo url('loja'); ?>" class="menu-link" aria-label="Loja">
                            <i class="fas fa-shopping-cart" aria-hidden="true"></i>
                            <span>Loja</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                    <li class="menu-item">
                        <a href="https://lucas.br.vc/" class="menu-link" target="_blank" aria-label="Contato">
                            <i class="fas fa-envelope" aria-hidden="true"></i>
                            <span>Contato</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                </ul>
                
                <div class="menu-footer">
                    <div class="social-icons">
                        <a href="#" class="social-icon"><i class="fab fa-twitter"></i></a>
                        <a href="#" class="social-icon"><i class="fab fa-github"></i></a>
                        <a href="#" class="social-icon"><i class="fab fa-linkedin"></i></a>
                    </div>
                    <div class="admin-menu-access">
                        <a href="<?php echo url('admin/'); ?>" class="admin-menu-btn" title="Painel Admin">
                            <i class="fas fa-cogs"></i>
                        </a>
                    </div>
                </div>
            </div>
        </nav>
    </div>

    <!-- Preloader otimizado -->
    <?php include 'preloader-optimized.php'; ?>

    <div id="main-content">
        <header>
            <div class="container">
                <div class="logo">
                    <h1>CyberNews</h1>
                </div>
                <p class="tagline">Agregador automático de notícias de segurança da informação</p>
            </div>
        </header>

        <main class="main-content">
            <div class="content-wrapper">
                <!-- 🚀 SIDEBAR ESQUERDA COM ANÚNCIOS -->
                <aside class="sidebar-left">
                    <div class="sidebar-content">
                        <!-- Anúncio AdSense Sidebar Esquerda 1 -->
                        <div class="sidebar-ad-section">
                            <div class="ad-container ad-sidebar">
                                <div class="ad-label">📢 Publicidade</div>
                                <?php 
                                if (function_exists('renderAdSense')) {
                                    echo renderAdSense('sidebar-left-top');
                                } else {
                                    echo '<div class="ad-placeholder">
                                        <i class="fas fa-ad"></i>
                                        <p>Anúncio Google AdSense</p>
                                        <small>Configure seu código no painel admin</small>
                                    </div>';
                                }
                                ?>
                            </div>
                        </div>
                        
                        <!-- Anúncio AdSense Sidebar Esquerda 2 -->
                        <div class="sidebar-ad-section">
                            <div class="ad-container ad-sidebar">
                                <div class="ad-label">📢 Publicidade</div>
                                <?php 
                                if (function_exists('renderAdSense')) {
                                    echo renderAdSense('sidebar-left-bottom');
                                } else {
                                    echo '<div class="ad-placeholder">
                                        <i class="fas fa-ad"></i>
                                        <p>Anúncio Google AdSense</p>
                                        <small>Configure seu código no painel admin</small>
                                    </div>';
                                }
                                ?>
                            </div>
                        </div>
                    </div>
                </aside>
                
                <div class="main-content-area">
            <!-- Carousel de Notícias em Destaque -->
            <section class="featured-carousel">
                <div class="carousel-wrapper">
                    <div class="carousel-track" id="carousel-track">
                        <!-- Loading inicial canábico -->
                        <div class="carousel-loading">
                            <div style="display: flex; align-items: center; justify-content: center; height: 450px; background: linear-gradient(135deg, #2d5016, #4a7c23); border-radius: 15px; box-shadow: 0 0 20px rgba(0, 255, 100, 0.3);">
                                <div style="text-align: center; color: #90ee90;">
                                    <i class="fas fa-leaf fa-spin" style="font-size: 3rem; margin-bottom: 15px; color: #90ee90; text-shadow: 0 0 10px rgba(144, 238, 144, 0.5);"></i>
                                    <h3 style="color: #90ee90; text-shadow: 0 0 5px rgba(144, 238, 144, 0.3);">🌿 Carregando notícias em destaque...</h3>
                                    <p style="color: rgba(144, 238, 144, 0.8); margin-top: 10px;">Preparando o melhor conteúdo para você</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <button class="carousel-btn prev" id="carousel-prev">
                        <i class="fas fa-chevron-left"></i>
                    </button>
                    <button class="carousel-btn next" id="carousel-next">
                        <i class="fas fa-chevron-right"></i>
                    </button>
                    <div class="carousel-dots" id="carousel-dots">
                        <!-- Indicadores serão criados aqui -->
                    </div>
                </div>
            </section>

            <!-- SEÇÃO DE ARTIGOS MANUAIS EXCLUSIVOS -->
            <?php 
            // Incluir sistema de artigos manuais com tratamento de erro
            try {
                if (file_exists('backend/manual-articles.php')) {
                    require_once 'backend/manual-articles.php';
                    if (class_exists('ManualArticles')) {
                        $manualArticles = new ManualArticles();
                        echo $manualArticles->renderHomeSection();
                    } else {
                        echo '<div style="text-align: center; padding: 40px; color: #90ee90;">
                            <h3>🛡️ Artigos Exclusivos CyberNews</h3>
                            <p>Carregando artigos...</p>
                        </div>';
                    }
                } else {
                    echo '<div style="text-align: center; padding: 40px; color: #90ee90;">
                        <h3>🛡️ Artigos Exclusivos CyberNews</h3>
                        <p>Configurando sistema de artigos...</p>
                    </div>';
                }
            } catch (Exception $e) {
                // Em caso de erro, não quebrar o site
                echo '<div style="text-align: center; padding: 40px; color: #90ee90;">
                    <h3>🛡️ Artigos Exclusivos CyberNews</h3>
                    <p>Sistema de artigos em manutenção</p>
                </div>';
            }
            ?>
            

            
            <!-- 🌿 SEÇÃO DE AFILIADOS PREMIUM -->
            <?php 
            try {
                if (file_exists('affiliate-section.php')) {
                    include 'affiliate-section.php';
                } else {
                    echo '<div style="text-align: center; padding: 40px; color: #90ee90;">
                        <h3>🌿 Produtos Afiliados Canábicos</h3>
                        <p>Carregando produtos de cibersegurança...</p>
                    </div>';
                }
            } catch (Exception $e) {
                // Em caso de erro, não quebrar o site
                echo '<div style="text-align: center; padding: 40px; color: #90ee90;">
                    <h3>🌿 Produtos Afiliados Canábicos</h3>
                    <p>Sistema de afiliados em manutenção</p>
                </div>';
            }
            ?>

            <!-- SISTEMA DE MONETIZAÇÃO INTEGRADO! -->
            <?php 
            try {
                if (file_exists('adsense-setup.php')) {
                    include 'adsense-setup.php';
                }
                if (file_exists('monetization-system.php')) {
                    include 'monetization-system.php';
                }
            } catch (Exception $e) {
                // Em caso de erro, não quebrar o site
                echo '<div style="text-align: center; padding: 40px; color: #90ee90;">
                    <h3>💰 Sistema de Monetização</h3>
                    <p>Carregando ferramentas de monetização...</p>
                </div>';
            }
            ?>
            

            
            <div class="section-header">
                <h2 class="section-title">Últimas Notícias</h2>
                <div class="section-line"></div>
            </div>

            <!-- Filtros de idioma -->
            <section class="filter-container">
                <div class="language-filter">
                    <span>Filtrar por idioma:</span>
                    <button class="filter-btn active" data-filter="all">Todos</button>
                    <button class="filter-btn" data-filter="pt-BR">Português</button>
                    <button class="filter-btn" data-filter="en-US">Inglês</button>
                </div>
                <div class="search-container">
                    <input type="text" id="search-input" placeholder="Buscar notícias..." maxlength="100">
                    <button id="search-btn"><i class="fas fa-search"></i></button>
                    <button id="clear-search" style="display: none;"><i class="fas fa-times"></i></button>
                </div>
            </section>

            <!-- Grid de notícias com scroll infinito -->
            <section class="news-grid" id="news-grid">
                <!-- Notícias serão carregadas dinamicamente via JavaScript -->
            </section>
            
            <!-- Template para cards de notícias -->
            <template id="news-card-template">
                <article class="news-card" data-article-id="">
                    <div class="language-indicator"></div>
                    <div class="news-image">
                        <img src="" alt="" loading="lazy">
                        <div class="image-placeholder"></div>
                    </div>
                    <div class="news-content">
                        <div class="news-meta">
                            <span class="source-name"></span>
                            <span class="publish-date"></span>
                        </div>
                        <h3 class="news-title"></h3>
                        <p class="news-description"></p>
                        <div class="news-footer">
                            <a href="#" class="read-more" target="_blank">
                                Leia no site original <i class="fas fa-external-link-alt"></i>
                            </a>
                            <div class="news-stats">
                                <span class="views-count">
                                    <i class="fas fa-eye"></i> <span class="count">0</span>
                                </span>
                            </div>
                        </div>
                    </div>
                </article>
            </template>
                </div><!-- .main-content-area -->
                
                <!-- 🚀 SIDEBAR DIREITA COM ANÚNCIOS -->
                <aside class="sidebar-right">
                    <div class="sidebar-content">
                        <!-- Anúncio AdSense Sidebar Direita 1 -->
                        <div class="sidebar-ad-section">
                            <div class="ad-container ad-sidebar">
                                <div class="ad-label">📢 Publicidade</div>
                                <?php 
                                if (function_exists('renderAdSense')) {
                                    echo renderAdSense('sidebar-right-top');
                                } else {
                                    echo '<div class="ad-placeholder">
                                        <i class="fas fa-ad"></i>
                                        <p>Anúncio Google AdSense</p>
                                        <small>Configure seu código no painel admin</small>
                                    </div>';
                                }
                                ?>
                            </div>
                        </div>
                        
                        <!-- Anúncio AdSense Sidebar Direita 2 -->
                        <div class="sidebar-ad-section">
                            <div class="ad-container ad-sidebar">
                                <div class="ad-label">📢 Publicidade</div>
                                <?php 
                                if (function_exists('renderAdSense')) {
                                    echo renderAdSense('sidebar-right-bottom');
                                } else {
                                    echo '<div class="ad-placeholder">
                                        <i class="fas fa-ad"></i>
                                        <p>Anúncio Google AdSense</p>
                                        <small>Configure seu código no painel admin</small>
                                    </div>';
                                }
                                ?>
                            </div>
                        </div>
                    </div>
                </aside>
            </div><!-- .content-wrapper -->
        </main>



        <footer>
            <div class="container">
                <div class="footer-content">
                    <div class="footer-logo">
                        🛡️
                        <h2>CyberNews</h2>
                    </div>
                    <p>Seu portal de notícias sobre cibersegurança. Agregando conteúdo dos melhores sites especializados.</p>
                </div>
                <div class="copyright">
                    <p>&copy; <?= date('Y') ?> CyberNews - Todas as notícias são de propriedade de seus respectivos sites.</p>
                </div>
            </div>
        </footer>
    </div>

    <!-- Scripts otimizados -->
    <script src="<?php echo $isAcessoRestrito ? asset('js/performance.js') : 'js/performance.js'; ?>" defer></script>
    <script src="<?php echo $isAcessoRestrito ? asset('js/modals.js') : 'js/modals.js'; ?>" defer></script>
    <script src="<?php echo $isAcessoRestrito ? asset('script.js') : 'script.js'; ?>" defer></script>
    <script src="<?php echo $isAcessoRestrito ? asset('js/news-system.js') : 'js/news-system.js'; ?>" defer></script>
    
    <?php if ($isMobile): ?>
    <!-- Otimizações específicas para mobile -->
    <script>
    // Lazy loading de imagens para mobile
    if ('IntersectionObserver' in window) {
        const imageObserver = new IntersectionObserver((entries, observer) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    const img = entry.target;
                    img.src = img.dataset.src;
                    img.classList.add('loaded');
                    imageObserver.unobserve(img);
                }
            });
        });
        
        document.querySelectorAll('img[data-src]').forEach(img => {
            imageObserver.observe(img);
        });
    }
    </script>
    <?php endif; ?>
</body>
</html>