<?php
require_once 'domain-config.php';
header('Content-Type: text/html; charset=utf-8');
date_default_timezone_set('America/Sao_Paulo');
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Loja de Códigos - Scripts e Ferramentas de Cibersegurança | CyberNews</title>
    <meta name="description" content="Compre scripts e ferramentas de cibersegurança: scanners, bots de pentest, forense e APIs. Pagamento via Stripe, PIX e Criptomoedas.">
    <meta name="robots" content="index,follow">
    <link rel="canonical" href="<?php
require_once 'domain-config.php'; echo url('loja'); ?>">

    <!-- Open Graph -->
    <meta property="og:title" content="Loja de Códigos - CyberNews">
    <meta property="og:description" content="Scripts e ferramentas de cibersegurança à venda.">
    <meta property="og:type" content="website">
    <meta property="og:url" content="/loja">
    <meta property="og:site_name" content="CyberNews">

    <link rel="stylesheet" href="<?php echo asset('styles.css'); ?>">
    <link rel="stylesheet" href="<?php echo asset('css/news-psychedelic.css'); ?>">
    <link rel="stylesheet" href="<?php echo asset('css/store.css'); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
    
    <!-- Google Analytics -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-JBDJ3PPN93"></script>
    <script>
      window.dataLayer = window.dataLayer || [];
      function gtag(){dataLayer.push(arguments);}
      gtag('js', new Date());
      gtag('config', 'G-JBDJ3PPN93');
    </script>
</head>
<body class="psychedelic-mode">
    <!-- Preloader Psicodélico -->
    <div id="preloader">
        <div class="circuit-lines"></div>
        <div class="binary-text"></div>
        <div class="scan-line"></div>
        <div class="preloader-content">
            <div class="holo-container">
                <div class="rotating-ring"></div>
                <div class="rotating-ring"></div>
                <div class="rotating-ring"></div>
                <div class="tech-circle"></div>
                <div class="hex-spinner">
                    <div class="hex"></div>
                    <div class="hex"></div>
                    <div class="hex"></div>
                    <div class="hex"></div>
                    <div class="hex"></div>
                    <div class="hex"></div>
                </div>
                <div class="loading-bubbles">
                    <div class="bubble psychedelic"></div>
                    <div class="bubble psychedelic"></div>
                    <div class="bubble psychedelic"></div>
                    <div class="bubble psychedelic"></div>
                    <div class="bubble psychedelic"></div>
                    <div class="bubble psychedelic"></div>
                </div>
                <div class="digital-rain">
                    <div class="rain-column"></div>
                    <div class="rain-column"></div>
                    <div class="rain-column"></div>
                    <div class="rain-column"></div>
                    <div class="rain-column"></div>
                </div>
                <div class="neural-network">
                    <div class="node"></div>
                    <div class="node"></div>
                    <div class="node"></div>
                    <div class="node"></div>
                    <div class="connection"></div>
                    <div class="connection"></div>
                    <div class="connection"></div>
                </div>
                <div class="quantum-loader">
                    <div class="quantum-particle"></div>
                    <div class="quantum-particle"></div>
                    <div class="quantum-particle"></div>
                </div>
                <div class="neon-text">
                    <span class="glitch-text" data-text="LOJA">LOJA</span>
                    <div class="loading-dots">
                        <span></span><span></span><span></span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <a href="#conteudo" class="sr-only" style="position:absolute;left:-9999px;">Pular para o conteúdo</a>

    <!-- Botão Voltar ao Topo -->
    <div class="back-to-top">
        <i class="fas fa-arrow-up"></i>
    </div>


    <!-- Menu Lateral Alucinado -->
    <div class="psychedelic-menu-container">
        <div class="menu-toggle">
            <div class="hamburger">
                <span></span>
                <span></span>
                <span></span>
            </div>
        </div>
        
        <nav class="side-menu">
            <div class="menu-background">
                <div class="liquid-shape"></div>
                <div class="fractal-pattern"></div>
                <div class="glow-particles"></div>
            </div>
            
            <div class="menu-content">
                <div class="menu-header">
                    <div class="menu-logo">
                        <h2>CyberNews</h2>
                    </div>
                </div>
                
                <ul class="menu-items">
                    <li class="menu-item">
                        <a href="<?php
require_once 'domain-config.php'; echo url(''); ?>" class="menu-link">
                            <i class="fas fa-home"></i>
                            <span>Início</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                    <li class="menu-item">
                        <a href="<?php
require_once 'domain-config.php'; echo url('noticias'); ?>" class="menu-link">
                            <i class="fas fa-newspaper"></i>
                            <span>Notícias</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                    <li class="menu-item">
                        <a href="<?php
require_once 'domain-config.php'; echo url('seguranca'); ?>" class="menu-link">
                            <i class="fas fa-lock"></i>
                            <span>Segurança</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                    <li class="menu-item">
                        <a href="<?php
require_once 'domain-config.php'; echo url('vulnerabilidades'); ?>" class="menu-link">
                            <i class="fas fa-bug"></i>
                            <span>Vulnerabilidades</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                    <li class="menu-item">
                        <a href="<?php
require_once 'domain-config.php'; echo url('malware'); ?>" class="menu-link">
                            <i class="fas fa-virus"></i>
                            <span>Malware</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                    <li class="menu-item">
                        <a href="<?php
require_once 'domain-config.php'; echo url('privacidade'); ?>" class="menu-link">
                            <i class="fas fa-user-secret"></i>
                            <span>Privacidade</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                    <li class="menu-item active">
                        <a href="<?php
require_once 'domain-config.php'; echo url('loja'); ?>" class="menu-link" aria-label="Loja">
                            <i class="fas fa-shopping-cart" aria-hidden="true"></i>
                            <span>Loja</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                    <li class="menu-item">
                        <a href="https://lucas.br.vc/" class="menu-link" target="_blank" aria-label="Contato">
                            <i class="fas fa-envelope" aria-hidden="true"></i>
                            <span>Contato</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                </ul>
                
                <div class="menu-footer">
                <div class="social-icons">
                    <a href="#" class="social-icon"><i class="fab fa-twitter"></i></a>
                    <a href="#" class="social-icon"><i class="fab fa-github"></i></a>
                    <a href="#" class="social-icon"><i class="fab fa-linkedin"></i></a>
                </div>
                <div class="admin-menu-access">
                    <a href="<?php echo url('admin/'); ?>" class="admin-menu-btn" title="Painel Admin">
                        <i class="fas fa-cogs"></i>
                    </a>
                </div>
            </div>
        </nav>
    </div>

    <header>
        <div class="container" role="banner">
            <div class="logo" aria-label="CyberNews Logo">
                <h1 style="margin:0;">CyberNews</h1>
            </div>
            <nav aria-label="Navegação principal">
                <a href="<?php
require_once 'domain-config.php'; echo url(''); ?>" class="admin-btn" style="text-decoration:none;">
                    <i class="fas fa-home" aria-hidden="true"></i> Início
                </a>
            </nav>
        </div>
    </header>

    <main id="conteudo" class="main-content" role="main">
        <div id="main-content">
        <div class="container">
            <section class="store-hero" aria-labelledby="store-title">
                <h1 id="store-title">🛒 Loja</h1>
                <p>Scripts e ferramentas de cibersegurança. Pagamentos processados via <strong>Stripe</strong>, <strong>PIX</strong> e <strong>Criptomoedas</strong>.</p>
            </section>

            <section class="product-grid" aria-label="Lista de produtos">
                <!-- Produto 1 -->
                <article class="product-card" role="article" aria-labelledby="prod1-title" aria-describedby="prod1-desc">
                    <h3 id="prod1-title">Scanner de Vulnerabilidades (CLI)</h3>
                    <p id="prod1-desc">Varredura rápida de portas, banners e CVEs conhecidas. Relatório em JSON/HTML.</p>
                    <div class="product-meta">
                        <span class="product-price" aria-label="Preço">R$ 89,00</span>
                        <button class="buy-button" data-product-id="scanner-cli" aria-label="Comprar Scanner de Vulnerabilidades">
                            🛒 Comprar
                        </button>
                    </div>
                </article>

                <!-- Produto 2 -->
                <article class="product-card" role="article" aria-labelledby="prod2-title" aria-describedby="prod2-desc">
                    <h3 id="prod2-title">Bot de Pentest Automatizado</h3>
                    <p id="prod2-desc">Execução automatizada de checks OWASP Top 10 com export PDF.</p>
                    <div class="product-meta">
                        <span class="product-price" aria-label="Preço">R$ 149,00</span>
                        <button class="buy-button" data-product-id="pentest-bot" aria-label="Comprar Bot de Pentest">
                            🛒 Comprar
                        </button>
                    </div>
                </article>

                <!-- Produto 3 -->
                <article class="product-card" role="article" aria-labelledby="prod3-title" aria-describedby="prod3-desc">
                    <h3 id="prod3-title">Kit de Scripts de Forense</h3>
                    <p id="prod3-desc">Coleta de artefatos, timeline e hashing verificado. Pronto para laudos.</p>
                    <div class="product-meta">
                        <span class="product-price" aria-label="Preço">R$ 119,00</span>
                        <button class="buy-button" data-product-id="forense-kit" aria-label="Comprar Kit de Scripts de Forense">
                            🛒 Comprar
                        </button>
                    </div>
                </article>

                <!-- Produto 4 -->
                <article class="product-card" role="article" aria-labelledby="prod4-title" aria-describedby="prod4-desc">
                    <h3 id="prod4-title">Detector de Phishing (API)</h3>
                    <p id="prod4-desc">Classificador simples para URLs suspeitas. Retorno JSON com score.</p>
                    <div class="product-meta">
                        <span class="product-price" aria-label="Preço">R$ 99,00</span>
                        <button class="buy-button" data-product-id="phishing-api" aria-label="Comprar Detector de Phishing">
                            🛒 Comprar
                        </button>
                    </div>
                </article>
            </section>

            <!-- Nova Seção: Serviços de Configuração -->
            <section class="services-section" aria-label="Serviços de Configuração">
                <div class="section-header">
                    <h2>🔧 Serviços de Configuração</h2>
                    <p>Ajudamos você a configurar e implementar plataformas de cibersegurança</p>
                </div>
                
                <div class="services-grid">
                    <!-- Serviço 1 -->
                    <article class="service-card" role="article" aria-labelledby="serv1-title" aria-describedby="serv1-desc">
                        <div class="service-icon">
                            🖥️
                        </div>
                        <h3 id="serv1-title">Configuração de SIEM</h3>
                        <p id="serv1-desc">Implementação e configuração completa de plataformas SIEM (Splunk, Elastic Stack, QRadar)</p>
                        <ul class="service-features">
                            <li>✅ Instalação e configuração inicial</li>
                            <li>✅ Criação de dashboards personalizados</li>
                            <li>✅ Configuração de alertas e regras</li>
                            <li>✅ Treinamento da equipe (4h)</li>
                            <li>✅ 30 dias de suporte incluso</li>
                        </ul>
                        <div class="service-meta">
                            <span class="service-price" aria-label="Preço">R$ 2.500,00</span>
                            <button class="buy-button service-btn" data-product-id="siem-config" aria-label="Contratar Configuração SIEM">
                                🤝 Contratar
                            </button>
                        </div>
                    </article>

                    <!-- Serviço 2 -->
                    <article class="service-card" role="article" aria-labelledby="serv2-title" aria-describedby="serv2-desc">
                        <div class="service-icon">
                            🛡️
                        </div>
                        <h3 id="serv2-title">Setup de Firewall Corporativo</h3>
                        <p id="serv2-desc">Configuração profissional de firewalls (pfSense, FortiGate, SonicWall)</p>
                        <ul class="service-features">
                            <li>✅ Análise de infraestrutura atual</li>
                            <li>✅ Configuração de regras de segurança</li>
                            <li>✅ VPN site-to-site e client</li>
                            <li>✅ Monitoramento e logs</li>
                            <li>✅ Documentação técnica completa</li>
                        </ul>
                        <div class="service-meta">
                            <span class="service-price" aria-label="Preço">R$ 1.800,00</span>
                            <button class="buy-button service-btn" data-product-id="firewall-setup" aria-label="Contratar Setup Firewall">
                                🤝 Contratar
                            </button>
                        </div>
                    </article>

                    <!-- Serviço 3 -->
                    <article class="service-card" role="article" aria-labelledby="serv3-title" aria-describedby="serv3-desc">
                        <div class="service-icon">
                            🐛
                        </div>
                        <h3 id="serv3-title">Plataforma de Vulnerability Management</h3>
                        <p id="serv3-desc">Implementação de soluções de gestão de vulnerabilidades (Nessus, OpenVAS, Rapid7)</p>
                        <ul class="service-features">
                            <li>✅ Instalação e configuração da plataforma</li>
                            <li>✅ Criação de políticas de scan</li>
                            <li>✅ Integração com ferramentas existentes</li>
                            <li>✅ Relatórios automatizados</li>
                            <li>✅ Workflow de correção de vulnerabilidades</li>
                        </ul>
                        <div class="service-meta">
                            <span class="service-price" aria-label="Preço">R$ 3.200,00</span>
                            <button class="buy-button service-btn" data-product-id="vuln-mgmt-setup" aria-label="Contratar Configuração Vulnerability Management">
                                🤝 Contratar
                            </button>
                        </div>
                    </article>

                    <!-- Serviço 4 -->
                    <article class="service-card" role="article" aria-labelledby="serv4-title" aria-describedby="serv4-desc">
                        <div class="service-icon">
                            👁️
                        </div>
                        <h3 id="serv4-title">SOC as a Service - Setup</h3>
                        <p id="serv4-desc">Implementação completa de Centro de Operações de Segurança (SOC)</p>
                        <ul class="service-features">
                            <li>✅ Arquitetura e design do SOC</li>
                            <li>✅ Configuração de ferramentas integradas</li>
                            <li>✅ Playbooks de resposta a incidentes</li>
                            <li>✅ Treinamento da equipe SOC (8h)</li>
                            <li>✅ 60 dias de suporte especializado</li>
                        </ul>
                        <div class="service-meta">
                            <span class="service-price" aria-label="Preço">R$ 5.500,00</span>
                            <button class="buy-button service-btn" data-product-id="soc-setup" aria-label="Contratar Setup SOC">
                                🤝 Contratar
                            </button>
                        </div>
                    </article>

                    <!-- Serviço 5 -->
                    <article class="service-card" role="article" aria-labelledby="serv5-title" aria-describedby="serv5-desc">
                        <div class="service-icon">
                            ☁️
                        </div>
                        <h3 id="serv5-title">Migração Segura para Cloud</h3>
                        <p id="serv5-desc">Consultoria especializada para migração segura para AWS, Azure ou GCP</p>
                        <ul class="service-features">
                            <li>✅ Análise de segurança atual</li>
                            <li>✅ Planejamento de migração</li>
                            <li>✅ Configuração de segurança na cloud</li>
                            <li>✅ Compliance e governança</li>
                            <li>✅ Monitoramento e alertas</li>
                        </ul>
                        <div class="service-meta">
                            <span class="service-price" aria-label="Preço">R$ 4.200,00</span>
                            <button class="buy-button service-btn" data-product-id="cloud-migration" aria-label="Contratar Migração Cloud">
                                🤝 Contratar
                            </button>
                        </div>
                    </article>

                    <!-- Serviço 6 -->
                    <article class="service-card" role="article" aria-labelledby="serv6-title" aria-describedby="serv6-desc">
                        <div class="service-icon">
                            🎓
                        </div>
                        <h3 id="serv6-title">Treinamento Personalizado</h3>
                        <p id="serv6-desc">Treinamentos customizados em cibersegurança para sua equipe</p>
                        <ul class="service-features">
                            <li>✅ Análise de necessidades da equipe</li>
                            <li>✅ Conteúdo personalizado</li>
                            <li>✅ Simulações práticas</li>
                            <li>✅ Material didático incluso</li>
                            <li>✅ Certificado de participação</li>
                        </ul>
                        <div class="service-meta">
                            <span class="service-price" aria-label="Preço">R$ 1.200,00</span>
                            <span class="service-unit">/dia</span>
                            <button class="buy-button service-btn" data-product-id="custom-training" aria-label="Contratar Treinamento">
                                🤝 Contratar
                            </button>
                        </div>
                    </article>
                </div>

                <div class="services-footer">
                    <div class="contact-info">
                        <h4>🤝 Precisa de algo personalizado?</h4>
                        <p>Entre em contato conosco para orçamentos customizados</p>
                        <a href="mailto:mcbfk1981@gmail.com" class="contact-btn">
                            <i class="fas fa-envelope"></i> mcbfk1981@gmail.com
                        </a>
                        <a href="https://wa.me/5511913739736" class="whatsapp-btn" target="_blank">
                            <i class="fab fa-whatsapp"></i> WhatsApp
                        </a>
                    </div>
                </div>
            </section>

            <section aria-label="Informações de compra">
                <p style="color:#b7e4b7;font-size:0.95rem;">
                    Pagamentos processados via <strong>Stripe</strong>, <strong>PIX</strong> e <strong>Criptomoedas</strong> (PayRam).
                    Após a compra, o download será liberado por link seguro e expira em 24h.
                </p>
            </section>
        </div>
        </div>
    </main>

    <footer>
        <div class="container">
            <div class="footer-content">
                <div class="footer-logo">
                    <h2>CyberNews</h2>
                </div>
                <p>Scripts e ferramentas para profissionais de segurança.</p>
            </div>
            <div class="copyright">
                <p>&copy; <?= date('Y') ?> CyberNews - Todos os direitos reservados.</p>
            </div>
        </div>
    </footer>

    <!-- Scripts otimizados -->
    <script src="https://js.stripe.com/v3/" defer></script>
    <script src="<?php echo asset('js/performance.js'); ?>" defer></script>
    <script src="<?php echo asset('js/modals.js'); ?>" defer></script>
    <script src="/js/store.js" defer></script>
    <script src="<?php echo asset('script.js'); ?>" defer></script>
</body>
</html>


