<?php
header('Content-Type: text/html; charset=utf-8');
date_default_timezone_set('America/Sao_Paulo');
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Malware & Análise | CyberNews</title>
    <meta name="description" content="Análise de malware, detecção de ameaças, sandbox analysis e inteligência sobre as últimas campanhas maliciosas.">
    <meta name="robots" content="index,follow">
    <link rel="canonical" href="<?php echo url('malware'); ?>">

    <!-- Open Graph -->
    <meta property="og:title" content="Malware & Análise - CyberNews">
    <meta property="og:description" content="Centro de análise de malware e inteligência de ameaças.">
    <meta property="og:type" content="website">
    <meta property="og:url" content="/malware">
    <meta property="og:site_name" content="CyberNews">

    <link rel="stylesheet" href="<?php echo asset('styles.css'); ?>">
    <link rel="stylesheet" href="<?php echo asset('css/news-psychedelic.css'); ?>">
    <link rel="stylesheet" href="<?php echo asset('css/sections.css'); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
</head>
<body class="psychedelic-mode">
    <!-- Preloader -->
    <div id="preloader">
        <div class="circuit-lines"></div>
        <div class="binary-text"></div>
        <div class="scan-line"></div>
        <div class="preloader-content">
            <div class="holo-container">
                <div class="rotating-ring"></div>
                <div class="rotating-ring"></div>
                <div class="rotating-ring"></div>
                <div class="tech-circle"></div>
                <div class="hex-spinner">
                    <div class="hex"></div>
                    <div class="hex"></div>
                    <div class="hex"></div>
                    <div class="hex"></div>
                    <div class="hex"></div>
                    <div class="hex"></div>
                </div>
                <div class="loading-bubbles">
                    <div class="bubble psychedelic"></div>
                    <div class="bubble psychedelic"></div>
                    <div class="bubble psychedelic"></div>
                    <div class="bubble psychedelic"></div>
                    <div class="bubble psychedelic"></div>
                    <div class="bubble psychedelic"></div>
                </div>
                <div class="neon-text">
                    <span class="glitch-text" data-text="MALWARE">MALWARE</span>
                    <div class="loading-dots">
                        <span></span><span></span><span></span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Botão Voltar ao Topo -->
    <div class="back-to-top">
        <i class="fas fa-arrow-up"></i>
    </div>

    <!-- Menu Lateral -->
    <div class="psychedelic-menu-container">
        <div class="menu-toggle">
            <div class="hamburger">
                <span></span>
                <span></span>
                <span></span>
            </div>
        </div>
        
        <nav class="side-menu">
            <div class="menu-background">
                <div class="liquid-shape"></div>
                <div class="fractal-pattern"></div>
                <div class="glow-particles"></div>
            </div>
            
            <div class="menu-content">
                <div class="menu-header">
                    <div class="menu-logo">
                        <h2>CyberNews</h2>
                    </div>
                </div>
                
                <ul class="menu-items">
                    <li class="menu-item">
                        <a href="<?php echo url(''); ?>" class="menu-link">
                            <i class="fas fa-home"></i>
                            <span>Início</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                    <li class="menu-item">
                        <a href="<?php echo url('noticias'); ?>" class="menu-link">
                            <i class="fas fa-newspaper"></i>
                            <span>Notícias</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                    <li class="menu-item">
                        <a href="<?php echo url('seguranca'); ?>" class="menu-link">
                            <i class="fas fa-lock"></i>
                            <span>Segurança</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                    <li class="menu-item">
                        <a href="<?php echo url('vulnerabilidades'); ?>" class="menu-link">
                            <i class="fas fa-bug"></i>
                            <span>Vulnerabilidades</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                    <li class="menu-item active">
                        <a href="<?php echo url('malware'); ?>" class="menu-link">
                            <i class="fas fa-virus"></i>
                            <span>Malware</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                    <li class="menu-item">
                        <a href="<?php echo url('privacidade'); ?>" class="menu-link">
                            <i class="fas fa-user-secret"></i>
                            <span>Privacidade</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                    <li class="menu-item">
                        <a href="<?php echo url('loja'); ?>" class="menu-link" aria-label="Loja">
                            <i class="fas fa-shopping-cart" aria-hidden="true"></i>
                            <span>Loja</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                    <li class="menu-item">
                        <a href="https://lucas.br.vc/" class="menu-link" target="_blank" aria-label="Contato">
                            <i class="fas fa-envelope" aria-hidden="true"></i>
                            <span>Contato</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                </ul>
                
                <div class="menu-footer">
                    <div class="social-icons">
                        <a href="#" class="social-icon"><i class="fab fa-twitter"></i></a>
                        <a href="#" class="social-icon"><i class="fab fa-github"></i></a>
                        <a href="#" class="social-icon"><i class="fab fa-linkedin"></i></a>
                    </div>
                    <div class="admin-menu-access">
                        <a href="/admin/" class="admin-menu-btn" title="Painel Admin">
                            <i class="fas fa-cogs"></i>
                        </a>
                    </div>
                </div>
            </div>
        </nav>
    </div>

    <header>
        <div class="container" role="banner">
            <div class="logo" aria-label="CyberNews Logo">
                <h1 style="margin:0;">CyberNews</h1>
            </div>
            <nav aria-label="Navegação principal">
                <a href="<?php echo url(''); ?>" class="admin-btn" style="text-decoration:none;">
                    <i class="fas fa-home" aria-hidden="true"></i> Início
                </a>
            </nav>
        </div>
    </header>

    <main class="main-content" role="main">
        <div id="main-content">
            <div class="container">
                <section class="store-hero" aria-labelledby="malware-title">
                    <h1 id="malware-title">🦠 Centro de Análise de Malware</h1>
                    <p>Análise forense, detecção de ameaças e inteligência sobre as campanhas maliciosas mais recentes.</p>
                </section>

                <!-- Dashboard de Ameaças -->
                <section class="malware-dashboard" aria-label="Dashboard de Ameaças">
                    <div class="section-header">
                        <h2>🚨 Status Global de Malware</h2>
                        <p>Panorama em tempo real das ameaças ativas</p>
                    </div>
                    
                    <div class="vuln-stats">
                        <div class="stat-card critical">
                            <div class="stat-icon">
                                <i class="fas fa-skull-crossbones"></i>
                            </div>
                            <div class="stat-content">
                                <h3>1,247</h3>
                                <p>Malware Ativo<br><small>Últimas 24 horas</small></p>
                            </div>
                        </div>
                        <div class="stat-card high">
                            <div class="stat-icon">
                                <i class="fas fa-lock"></i>
                            </div>
                            <div class="stat-content">
                                <h3>89</h3>
                                <p>Ransomware<br><small>Novas variantes</small></p>
                            </div>
                        </div>
                        <div class="stat-card medium">
                            <div class="stat-icon">
                                <i class="fas fa-eye"></i>
                            </div>
                            <div class="stat-content">
                                <h3>2,156</h3>
                                <p>Spyware<br><small>Campanhas ativas</small></p>
                            </div>
                        </div>
                        <div class="stat-card data-breaches">
                            <div class="stat-icon">
                                <i class="fas fa-robot"></i>
                            </div>
                            <div class="stat-content">
                                <h3>567</h3>
                                <p>Botnets<br><small>Redes identificadas</small></p>
                            </div>
                        </div>
                    </div>
                </section>

                <!-- Análise de Malware Recente -->
                <section class="malware-analysis" aria-label="Análises Recentes">
                    <div class="section-header">
                        <h2>🔬 Análises de Laboratório</h2>
                        <p>Dissecação técnica dos malwares mais perigosos</p>
                    </div>
                    
                    <div class="analysis-grid">
                        <!-- Análise 1 -->
                        <article class="analysis-card critical">
                            <div class="malware-header">
                                <div class="malware-family">Ransomware</div>
                                <div class="threat-level critical">CRÍTICO</div>
                            </div>
                            <h3>🔒 BlackCat 2.0 - Nova Variante</h3>
                            <p>Ransomware-as-a-Service com criptografia dupla e técnicas de evasão avançadas.</p>
                            
                            <div class="malware-details">
                                <div class="detail-row">
                                    <strong>Hash SHA256:</strong>
                                    <code>a1b2c3d4e5f6789...</code>
                                </div>
                                <div class="detail-row">
                                    <strong>Primeira Detecção:</strong>
                                    <span>2024-09-10 14:30 UTC</span>
                                </div>
                                <div class="detail-row">
                                    <strong>Vetores de Ataque:</strong>
                                    <span>Email, RDP, Vulnerabilidades</span>
                                </div>
                                <div class="detail-row">
                                    <strong>Sistemas Afetados:</strong>
                                    <span>Windows 10/11, Server 2019/2022</span>
                                </div>
                            </div>

                            <div class="ioc-section">
                                <h4>🎯 Indicadores de Compromisso (IOCs)</h4>
                                <div class="ioc-list">
                                    <div class="ioc-item">
                                        <strong>Domínio C&C:</strong> <code>evil-command.onion</code>
                                    </div>
                                    <div class="ioc-item">
                                        <strong>IP:</strong> <code>192.168.1.100</code>
                                    </div>
                                    <div class="ioc-item">
                                        <strong>Registry Key:</strong> <code>HKLM\Software\BlackCat</code>
                                    </div>
                                </div>
                            </div>

                            <div class="analysis-actions">
                                <a href="#" class="analysis-btn primary">📄 Relatório Completo</a>
                                <a href="#" class="analysis-btn">💾 Download IOCs</a>
                                <a href="#" class="analysis-btn">🛡️ YARA Rules</a>
                            </div>
                        </article>

                        <!-- Análise 2 -->
                        <article class="analysis-card high">
                            <div class="malware-header">
                                <div class="malware-family">Banking Trojan</div>
                                <div class="threat-level high">ALTO</div>
                            </div>
                            <h3>💰 QakBot Evolution - Módulo Bancário</h3>
                            <p>Trojan bancário modular com capacidades de roubo de credenciais e propagação lateral.</p>
                            
                            <div class="malware-details">
                                <div class="detail-row">
                                    <strong>Hash SHA256:</strong>
                                    <code>f7e8d9c0b1a2345...</code>
                                </div>
                                <div class="detail-row">
                                    <strong>Primeira Detecção:</strong>
                                    <span>2024-09-09 08:15 UTC</span>
                                </div>
                                <div class="detail-row">
                                    <strong>Alvos Principais:</strong>
                                    <span>Bancos brasileiros, Fintechs</span>
                                </div>
                                <div class="detail-row">
                                    <strong>Técnicas TTPs:</strong>
                                    <span>Process Injection, Keylogging</span>
                                </div>
                            </div>

                            <div class="ioc-section">
                                <h4>🎯 Indicadores de Compromisso (IOCs)</h4>
                                <div class="ioc-list">
                                    <div class="ioc-item">
                                        <strong>URL Phishing:</strong> <code>banco-falso.com.br</code>
                                    </div>
                                    <div class="ioc-item">
                                        <strong>Mutex:</strong> <code>QakBot_2024_v2</code>
                                    </div>
                                    <div class="ioc-item">
                                        <strong>User-Agent:</strong> <code>Mozilla/5.0 QakBot</code>
                                    </div>
                                </div>
                            </div>

                            <div class="analysis-actions">
                                <a href="#" class="analysis-btn primary">📄 Análise Técnica</a>
                                <a href="#" class="analysis-btn">🏦 Bancos Afetados</a>
                                <a href="#" class="analysis-btn">🛡️ Proteção</a>
                            </div>
                        </article>

                        <!-- Análise 3 -->
                        <article class="analysis-card medium">
                            <div class="malware-header">
                                <div class="malware-family">Infostealer</div>
                                <div class="threat-level medium">MÉDIO</div>
                            </div>
                            <h3>🎣 Stealer-X - Coleta de Credenciais</h3>
                            <p>Malware focado em roubo de senhas, cookies e dados de navegadores e carteiras crypto.</p>
                            
                            <div class="malware-details">
                                <div class="detail-row">
                                    <strong>Hash SHA256:</strong>
                                    <code>3c4d5e6f7890abc...</code>
                                </div>
                                <div class="detail-row">
                                    <strong>Primeira Detecção:</strong>
                                    <span>2024-09-08 16:45 UTC</span>
                                </div>
                                <div class="detail-row">
                                    <strong>Dados Roubados:</strong>
                                    <span>Senhas, Cookies, Crypto Wallets</span>
                                </div>
                                <div class="detail-row">
                                    <strong>Distribuição:</strong>
                                    <span>Telegram, Discord, Fóruns</span>
                                </div>
                            </div>

                            <div class="ioc-section">
                                <h4>🎯 Indicadores de Compromisso (IOCs)</h4>
                                <div class="ioc-list">
                                    <div class="ioc-item">
                                        <strong>Telegram Bot:</strong> <code>@StealerX_bot</code>
                                    </div>
                                    <div class="ioc-item">
                                        <strong>Arquivo:</strong> <code>update.exe</code>
                                    </div>
                                    <div class="ioc-item">
                                        <strong>Pasta:</strong> <code>%TEMP%\sx_data</code>
                                    </div>
                                </div>
                            </div>

                            <div class="analysis-actions">
                                <a href="#" class="analysis-btn primary">📄 Análise Completa</a>
                                <a href="#" class="analysis-btn">🔍 Sandbox Report</a>
                                <a href="#" class="analysis-btn">💰 Crypto Theft</a>
                            </div>
                        </article>
                    </div>
                </section>

                <!-- Ferramentas de Análise -->
                <section class="analysis-tools" aria-label="Ferramentas de Análise">
                    <div class="section-header">
                        <h2>🛠️ Arsenal de Análise</h2>
                        <p>Ferramentas profissionais para análise e detecção de malware</p>
                    </div>
                    
                    <div class="tools-categories">
                        <div class="tool-category">
                            <h3>🔬 Análise Estática</h3>
                            <div class="tool-list">
                                <div class="tool-item">
                                    <div class="tool-header">
                                        <strong>IDA Pro</strong>
                                        <span class="tool-type commercial">COMERCIAL</span>
                                    </div>
                                    <p>Disassembler e debugger profissional para engenharia reversa</p>
                                    <div class="tool-features">
                                        <span>✅ Multi-architecture</span>
                                        <span>✅ Advanced decompiler</span>
                                        <span>✅ Plugin ecosystem</span>
                                        <span>✅ Collaborative analysis</span>
                                    </div>
                                    <a href="#" class="tool-link">Experimentar</a>
                                </div>
                                
                                <div class="tool-item">
                                    <div class="tool-header">
                                        <strong>Ghidra</strong>
                                        <span class="tool-type free">GRATUITO</span>
                                    </div>
                                    <p>Suite de engenharia reversa desenvolvida pela NSA</p>
                                    <div class="tool-features">
                                        <span>✅ NSA developed</span>
                                        <span>✅ Multi-platform</span>
                                        <span>✅ Scripting support</span>
                                        <span>✅ Collaborative features</span>
                                    </div>
                                    <a href="#" class="tool-link">Download</a>
                                </div>

                                <div class="tool-item">
                                    <div class="tool-header">
                                        <strong>PE-bear</strong>
                                        <span class="tool-type free">GRATUITO</span>
                                    </div>
                                    <p>Analisador de arquivos PE com interface gráfica amigável</p>
                                    <div class="tool-features">
                                        <span>✅ PE analysis</span>
                                        <span>✅ Section viewer</span>
                                        <span>✅ Import/Export</span>
                                        <span>✅ Hex editor</span>
                                    </div>
                                    <a href="#" class="tool-link">Download</a>
                                </div>
                            </div>
                        </div>

                        <div class="tool-category">
                            <h3>🏃‍♂️ Análise Dinâmica</h3>
                            <div class="tool-list">
                                <div class="tool-item">
                                    <div class="tool-header">
                                        <strong>Cuckoo Sandbox</strong>
                                        <span class="tool-type opensource">OPEN SOURCE</span>
                                    </div>
                                    <p>Sistema automatizado de análise de malware em ambiente isolado</p>
                                    <div class="tool-features">
                                        <span>✅ Automated analysis</span>
                                        <span>✅ VM orchestration</span>
                                        <span>✅ Behavioral analysis</span>
                                        <span>✅ API monitoring</span>
                                    </div>
                                    <a href="#" class="tool-link">Setup</a>
                                </div>

                                <div class="tool-item">
                                    <div class="tool-header">
                                        <strong>Any.run</strong>
                                        <span class="tool-type cloud">CLOUD</span>
                                    </div>
                                    <p>Sandbox interativo baseado em nuvem</p>
                                    <div class="tool-features">
                                        <span>✅ Interactive sandbox</span>
                                        <span>✅ Real-time analysis</span>
                                        <span>✅ Threat intelligence</span>
                                        <span>✅ MITRE ATT&CK</span>
                                    </div>
                                    <a href="#" class="tool-link">Analisar</a>
                                </div>

                                <div class="tool-item">
                                    <div class="tool-header">
                                        <strong>Process Monitor</strong>
                                        <span class="tool-type free">GRATUITO</span>
                                    </div>
                                    <p>Monitor de atividade de processos, arquivos e registry</p>
                                    <div class="tool-features">
                                        <span>✅ Real-time monitoring</span>
                                        <span>✅ File system</span>
                                        <span>✅ Registry tracking</span>
                                        <span>✅ Network activity</span>
                                    </div>
                                    <a href="#" class="tool-link">Download</a>
                                </div>
                            </div>
                        </div>

                        <div class="tool-category">
                            <h3>🕵️‍♂️ Threat Intelligence</h3>
                            <div class="tool-list">
                                <div class="tool-item">
                                    <div class="tool-header">
                                        <strong>VirusTotal</strong>
                                        <span class="tool-type freemium">FREEMIUM</span>
                                    </div>
                                    <p>Análise multi-engine com inteligência de ameaças global</p>
                                    <div class="tool-features">
                                        <span>✅ 70+ AV engines</span>
                                        <span>✅ Behavioral analysis</span>
                                        <span>✅ Threat hunting</span>
                                        <span>✅ API access</span>
                                    </div>
                                    <a href="#" class="tool-link">Analisar</a>
                                </div>

                                <div class="tool-item">
                                    <div class="tool-header">
                                        <strong>Hybrid Analysis</strong>
                                        <span class="tool-type free">GRATUITO</span>
                                    </div>
                                    <p>Sandbox gratuito com análise comportamental detalhada</p>
                                    <div class="tool-features">
                                        <span>✅ Free sandbox</span>
                                        <span>✅ Detailed reports</span>
                                        <span>✅ MITRE mapping</span>
                                        <span>✅ IOC extraction</span>
                                    </div>
                                    <a href="#" class="tool-link">Usar</a>
                                </div>

                                <div class="tool-item">
                                    <div class="tool-header">
                                        <strong>MISP</strong>
                                        <span class="tool-type opensource">OPEN SOURCE</span>
                                    </div>
                                    <p>Plataforma de compartilhamento de inteligência de ameaças</p>
                                    <div class="tool-features">
                                        <span>✅ Threat sharing</span>
                                        <span>✅ IOC management</span>
                                        <span>✅ Correlation engine</span>
                                        <span>✅ API integration</span>
                                    </div>
                                    <a href="#" class="tool-link">Deploy</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>

                <!-- Famílias de Malware -->
                <section class="malware-families" aria-label="Famílias de Malware">
                    <div class="section-header">
                        <h2>🧬 Taxonomia de Malware</h2>
                        <p>Classificação e características das principais famílias</p>
                    </div>
                    
                    <div class="families-grid">
                        <div class="family-card ransomware">
                            <div class="family-icon">
                                <i class="fas fa-lock"></i>
                            </div>
                            <h3>Ransomware</h3>
                            <p>Criptografia de arquivos com pedido de resgate</p>
                            <div class="family-stats">
                                <div class="stat">
                                    <span class="number">156</span>
                                    <span class="label">Famílias Ativas</span>
                                </div>
                                <div class="stat">
                                    <span class="number">$2.3B</span>
                                    <span class="label">Perdas em 2024</span>
                                </div>
                            </div>
                            <div class="notable-families">
                                <h5>Famílias Notáveis:</h5>
                                <ul>
                                    <li>• LockBit 3.0</li>
                                    <li>• BlackCat/ALPHV</li>
                                    <li>• Cl0p</li>
                                    <li>• Royal</li>
                                </ul>
                            </div>
                            <a href="#" class="family-btn">📊 Ver Estatísticas</a>
                        </div>

                        <div class="family-card banking">
                            <div class="family-icon">
                                <i class="fas fa-university"></i>
                            </div>
                            <h3>Banking Trojans</h3>
                            <p>Roubo de credenciais bancárias e financeiras</p>
                            <div class="family-stats">
                                <div class="stat">
                                    <span class="number">89</span>
                                    <span class="label">Variantes Ativas</span>
                                </div>
                                <div class="stat">
                                    <span class="number">45%</span>
                                    <span class="label">Foco no Brasil</span>
                                </div>
                            </div>
                            <div class="notable-families">
                                <h5>Famílias Notáveis:</h5>
                                <ul>
                                    <li>• QakBot</li>
                                    <li>• Emotet</li>
                                    <li>• TrickBot</li>
                                    <li>• Grandoreiro</li>
                                </ul>
                            </div>
                            <a href="#" class="family-btn">🏦 Análise Bancária</a>
                        </div>

                        <div class="family-card spyware">
                            <div class="family-icon">
                                <i class="fas fa-eye"></i>
                            </div>
                            <h3>Spyware</h3>
                            <p>Espionagem e coleta de dados pessoais</p>
                            <div class="family-stats">
                                <div class="stat">
                                    <span class="number">234</span>
                                    <span class="label">Campanhas Ativas</span>
                                </div>
                                <div class="stat">
                                    <span class="number">78%</span>
                                    <span class="label">Mobile Focus</span>
                                </div>
                            </div>
                            <div class="notable-families">
                                <h5>Famílias Notáveis:</h5>
                                <ul>
                                    <li>• Pegasus</li>
                                    <li>• FlexiSpy</li>
                                    <li>• mSpy</li>
                                    <li>• RedLine</li>
                                </ul>
                            </div>
                            <a href="#" class="family-btn">👁️ Detecção</a>
                        </div>

                        <div class="family-card botnet">
                            <div class="family-icon">
                                <i class="fas fa-network-wired"></i>
                            </div>
                            <h3>Botnets</h3>
                            <p>Redes de computadores infectados controlados remotamente</p>
                            <div class="family-stats">
                                <div class="stat">
                                    <span class="number">567</span>
                                    <span class="label">Redes Ativas</span>
                                </div>
                                <div class="stat">
                                    <span class="number">12.3M</span>
                                    <span class="label">Bots Infectados</span>
                                </div>
                            </div>
                            <div class="notable-families">
                                <h5>Famílias Notáveis:</h5>
                                <ul>
                                    <li>• Mirai</li>
                                    <li>• Emotet</li>
                                    <li>• Zeus</li>
                                    <li>• Conficker</li>
                                </ul>
                            </div>
                            <a href="#" class="family-btn">🌐 Rastreamento</a>
                        </div>
                    </div>
                </section>

                <!-- Sandbox Online -->
                <section class="sandbox-section" aria-label="Sandbox Online">
                    <div class="section-header">
                        <h2>🧪 Sandbox Gratuito</h2>
                        <p>Analise arquivos suspeitos em ambiente seguro</p>
                    </div>
                    
                    <div class="sandbox-interface">
                        <div class="upload-area">
                            <div class="upload-icon">
                                <i class="fas fa-cloud-upload-alt"></i>
                            </div>
                            <h3>Enviar Arquivo para Análise</h3>
                            <p>Arraste e solte ou clique para selecionar</p>
                            <div class="file-types">
                                <span>Suportados: .exe, .dll, .doc, .pdf, .zip</span>
                            </div>
                            <button class="upload-btn">📁 Selecionar Arquivo</button>
                        </div>
                        
                        <div class="analysis-progress" style="display: none;">
                            <div class="progress-header">
                                <h4>🔬 Análise em Progresso...</h4>
                                <div class="progress-bar">
                                    <div class="progress-fill"></div>
                                </div>
                            </div>
                            <div class="analysis-steps">
                                <div class="step active">
                                    <i class="fas fa-upload"></i>
                                    <span>Upload Concluído</span>
                                </div>
                                <div class="step">
                                    <i class="fas fa-search"></i>
                                    <span>Análise Estática</span>
                                </div>
                                <div class="step">
                                    <i class="fas fa-play"></i>
                                    <span>Execução Sandbox</span>
                                </div>
                                <div class="step">
                                    <i class="fas fa-chart-line"></i>
                                    <span>Relatório Final</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>

                <!-- Threat Intelligence Feed -->
                <section class="threat-feed" aria-label="Feed de Ameaças">
                    <div class="section-header">
                        <h2>📡 Intel Feed</h2>
                        <p>Inteligência de ameaças em tempo real</p>
                    </div>
                    
                    <div class="feed-container">
                        <div class="feed-item critical">
                            <div class="feed-time">Há 15 min</div>
                            <div class="feed-content">
                                <strong>Nova campanha de ransomware</strong> direcionada a hospitais brasileiros detectada
                            </div>
                            <div class="feed-severity critical">CRÍTICA</div>
                        </div>
                        
                        <div class="feed-item high">
                            <div class="feed-time">Há 1 hora</div>
                            <div class="feed-content">
                                <strong>Banking trojan brasileiro</strong> evolui com técnicas anti-VM avançadas
                            </div>
                            <div class="feed-severity high">ALTA</div>
                        </div>
                        
                        <div class="feed-item medium">
                            <div class="feed-time">Há 2 horas</div>
                            <div class="feed-content">
                                <strong>Botnet IoT</strong> infecta 50.000 dispositivos domésticos no Brasil
                            </div>
                            <div class="feed-severity medium">MÉDIA</div>
                        </div>
                        
                        <div class="feed-item high">
                            <div class="feed-time">Há 3 horas</div>
                            <div class="feed-content">
                                <strong>Stealer focado em crypto</strong> rouba R$ 2.3M de carteiras brasileiras
                            </div>
                            <div class="feed-severity high">ALTA</div>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </main>

    <footer>
        <div class="container">
            <div class="footer-content">
                <div class="footer-logo">
                    <h2>CyberNews</h2>
                </div>
                <p>Protegendo o mundo digital, uma análise de cada vez.</p>
            </div>
            <div class="copyright">
                <p>&copy; <?= date('Y') ?> CyberNews - Todos os direitos reservados.</p>
            </div>
        </div>
    </footer>
    
    <script src="<?php echo asset('js/performance.js'); ?>" defer></script>
    <script>
        // Função para criar modal de guia
        function showGuideModal(guideType, btn) {
            console.log('🧠 showGuideModal chamada:', guideType, btn);
            
            // Remover modal anterior se existir
            const existingModal = document.querySelector('.modal-overlay');
            if (existingModal) {
                existingModal.remove();
            }
            
            // Conteúdo baseado no tipo de guia
            let content = '';
            let title = '';
            
            if (guideType.includes('malware') || guideType.includes('vírus') || guideType.includes('virus')) {
                title = '🦠 Guia de Proteção contra Malware';
                content = `
                    <div style="text-align: left; color: #b9f9b9; line-height: 1.6;">
                        <h3 style="color: #90ee90; margin-bottom: 15px;">🛡️ Proteção contra Malware</h3>
                        <ul style="margin-bottom: 20px;">
                            <li>✅ Use antivírus atualizado</li>
                            <li>✅ Mantenha sistema operacional atualizado</li>
                            <li>✅ Evite downloads suspeitos</li>
                            <li>✅ Use sandboxing para arquivos suspeitos</li>
                            <li>✅ Configure firewall adequadamente</li>
                        </ul>
                        <h3 style="color: #90ee90; margin-bottom: 15px;">🔍 Detecção e Análise</h3>
                        <ul>
                            <li>🔍 Use ferramentas de análise de malware</li>
                            <li>📊 Monitore comportamento anômalo</li>
                            <li>🚨 Configure alertas de segurança</li>
                        </ul>
                    </div>
                `;
            } else if (guideType.includes('análise') || guideType.includes('analise')) {
                title = '🔬 Guia de Análise de Malware';
                content = `
                    <div style="text-align: left; color: #b9f9b9; line-height: 1.6;">
                        <h3 style="color: #90ee90; margin-bottom: 15px;">🔬 Análise de Malware</h3>
                        <ul style="margin-bottom: 20px;">
                            <li>✅ Use ambientes isolados (sandbox)</li>
                            <li>✅ Analise comportamento dinâmico</li>
                            <li>✅ Examine código estático</li>
                            <li>✅ Identifique IOCs (Indicators of Compromise)</li>
                            <li>✅ Documente descobertas</li>
                        </ul>
                        <h3 style="color: #90ee90; margin-bottom: 15px;">🛠️ Ferramentas</h3>
                        <ul>
                            <li>🔧 Use IDA Pro, Ghidra, x64dbg</li>
                            <li>🌐 Análise de rede com Wireshark</li>
                            <li>📊 Sandboxing com Cuckoo, Any.run</li>
                        </ul>
                    </div>
                `;
            } else {
                title = '🦠 Guia de Segurança contra Malware';
                content = `
                    <div style="text-align: left; color: #b9f9b9; line-height: 1.6;">
                        <h3 style="color: #90ee90; margin-bottom: 15px;">🛡️ Prevenção</h3>
                        <ul style="margin-bottom: 20px;">
                            <li>✅ Eduque usuários sobre phishing</li>
                            <li>✅ Implemente whitelisting de aplicações</li>
                            <li>✅ Use detecção comportamental</li>
                            <li>✅ Mantenha backups seguros</li>
                            <li>✅ Monitore tráfego de rede</li>
                        </ul>
                        <h3 style="color: #90ee90; margin-bottom: 15px;">🚨 Resposta a Incidentes</h3>
                        <ul>
                            <li>📋 Isole sistemas infectados</li>
                            <li>🔍 Analise escopo da infecção</li>
                            <li>🧹 Remova malware e restaure sistemas</li>
                        </ul>
                    </div>
                `;
            }
            
            const modal = document.createElement('div');
            modal.className = 'modal-overlay';
            modal.style.cssText = `
                position: fixed !important;
                top: 0 !important;
                left: 0 !important;
                width: 100% !important;
                height: 100% !important;
                background: rgba(0,0,0,0.95) !important;
                z-index: 999999 !important;
                display: flex !important;
                align-items: center !important;
                justify-content: center !important;
                visibility: visible !important;
                opacity: 1 !important;
            `;
            
            modal.innerHTML = `
                <div style="
                    background: linear-gradient(135deg, rgba(0,0,0,0.95), rgba(20,20,40,0.98)) !important;
                    border: 3px solid rgba(144, 238, 144, 0.6) !important;
                    border-radius: 20px !important;
                    padding: 40px !important;
                    max-width: 700px !important;
                    width: 90% !important;
                    max-height: 80vh !important;
                    overflow-y: auto !important;
                    box-shadow: 0 0 50px rgba(144, 238, 144, 0.3) !important;
                    position: relative !important;
                    z-index: 1000000 !important;
                ">
                    <h2 style="color: #90ee90 !important; margin-bottom: 25px !important; font-size: 24px !important; text-align: center !important;">${title}</h2>
                    ${content}
                    <div style="text-align: center; margin-top: 30px;">
                        <button onclick="this.closest('.modal-overlay').remove()" style="
                            background: linear-gradient(135deg, rgba(144, 238, 144, 0.3), rgba(144, 238, 144, 0.5)) !important;
                            border: 2px solid rgba(144, 238, 144, 0.7) !important;
                            color: #90ee90 !important;
                            padding: 15px 30px !important;
                            border-radius: 25px !important;
                            cursor: pointer !important;
                            font-size: 16px !important;
                            font-weight: bold !important;
                            margin-right: 15px !important;
                        ">Fechar</button>
                        <button onclick="
                            const email = 'lucasdeandrade0077@gmail.com';
                            const subject = 'Solicitação de Guia Completo - ${title}';
                            const body = 'Olá! Gostaria de receber o guia completo sobre: ${title}\\n\\nDetalhes:\\n- Tipo: ${guideType}\\n- Página: ${window.location.href}\\n\\nPor favor, envie o guia completo com mais detalhes e exemplos práticos.\\n\\nObrigado!';
                            window.open('mailto:' + email + '?subject=' + encodeURIComponent(subject) + '&body=' + encodeURIComponent(body));
                        " style="
                            background: linear-gradient(135deg, rgba(255, 165, 0, 0.3), rgba(255, 165, 0, 0.5)) !important;
                            border: 2px solid rgba(255, 165, 0, 0.7) !important;
                            color: #ffa500 !important;
                            padding: 15px 30px !important;
                            border-radius: 25px !important;
                            cursor: pointer !important;
                            font-size: 16px !important;
                            font-weight: bold !important;
                        ">📧 Solicitar Guia Completo</button>
                    </div>
                </div>
            `;
            
            document.body.appendChild(modal);
            console.log('✅ Modal de guia criado:', modal);
        }
        
        // Configurar botões "Ler Guia" quando a página carregar
        document.addEventListener('DOMContentLoaded', function() {
            console.log('🔍 Configurando botões "Ler Guia"...');
            
            // Aguardar um pouco para garantir que todos os elementos estão carregados
            setTimeout(function() {
                const guideButtons = document.querySelectorAll('button, a');
                console.log('🔍 Botões encontrados:', guideButtons.length);
                
                guideButtons.forEach(function(btn) {
                    const text = btn.textContent.toLowerCase();
                    if (text.includes('ler guia') || text.includes('guia')) {
                        console.log('🎯 Botão de guia encontrado:', btn.textContent);
                        
                        btn.addEventListener('click', function(e) {
                            e.preventDefault();
                            e.stopPropagation();
                            
                            console.log('🎯 Botão de guia clicado:', btn.textContent);
                            showGuideModal(btn.textContent, btn);
                        });
                    }
                });
            }, 1000);
        });
    </script>
    <script src="<?php echo asset('js/modals.js'); ?>" defer></script>
    <script src="<?php echo asset('script.js'); ?>" defer></script>
</body>
</html>
