<?php
// Script para mover as páginas para /acesso_restrito/

$pages = [
    'privacidade-acesso-restrito.php' => 'acesso_restrito/privacidade.php',
    'malware-acesso-restrito.php' => 'acesso_restrito/malware.php',
    'vulnerabilidades-acesso-restrito.php' => 'acesso_restrito/vulnerabilidades.php'
];

foreach ($pages as $source => $destination) {
    if (file_exists($source)) {
        if (copy($source, $destination)) {
            echo "✅ Movido: $source → $destination\n";
            unlink($source); // Remove o arquivo temporário
        } else {
            echo "❌ Erro ao mover: $source\n";
        }
    } else {
        echo "⚠️ Arquivo não encontrado: $source\n";
    }
}

echo "\n🎉 Processo concluído!\n";
?>
