<?php
require_once 'domain-config.php';
header('Content-Type: text/html; charset=utf-8');
date_default_timezone_set('America/Sao_Paulo');
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Notícias que Curam | CyberNews</title>
    <meta name="description" content="Notícias de cibersegurança que aliviam sua dor de cabeça. Soluções práticas, explicações simples e alívio para profissionais de TI.">
    <meta name="robots" content="index,follow">
    <link rel="canonical" href="<?php echo url('noticias'); ?>">

    <!-- Open Graph -->
    <meta property="og:title" content="Notícias que Curam - CyberNews">
    <meta property="og:description" content="Transformamos o estresse da cibersegurança em tranquilidade.">
    <meta property="og:type" content="website">
    <meta property="og:url" content="/noticias">
    <meta property="og:site_name" content="CyberNews">

    <link rel="stylesheet" href="<?php echo asset('styles.css'); ?>">
    <link rel="stylesheet" href="<?php echo asset('css/news-psychedelic.css'); ?>">
    <link rel="stylesheet" href="<?php echo asset('css/sections.css'); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
    
    <style>
        /* Estilos específicos para a página de notícias que curam */
        .pain-relief-section {
            background: linear-gradient(135deg, rgba(45, 80, 22, 0.1), rgba(16, 185, 129, 0.05));
            border-radius: 20px;
            padding: 40px;
            margin: 30px 0;
            border: 2px solid rgba(144, 238, 144, 0.3);
            position: relative;
            overflow: hidden;
        }

        .pain-relief-section::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: radial-gradient(circle at 30% 30%, rgba(144, 238, 144, 0.1), transparent 50%);
            animation: healing-pulse 4s ease-in-out infinite;
        }

        @keyframes healing-pulse {
            0%, 100% { opacity: 0.3; transform: scale(1); }
            50% { opacity: 0.6; transform: scale(1.02); }
        }

        .stress-meter {
            display: flex;
            align-items: center;
            gap: 15px;
            background: rgba(45, 80, 22, 0.6);
            padding: 20px;
            border-radius: 15px;
            margin-bottom: 30px;
        }

        .stress-level {
            flex: 1;
            height: 10px;
            background: rgba(255, 255, 255, 0.2);
            border-radius: 5px;
            overflow: hidden;
        }

        .stress-fill {
            height: 100%;
            background: linear-gradient(90deg, #10b981, #f7931e, #ff4757);
            border-radius: 5px;
            transition: width 0.5s ease;
        }

        .stress-fill.low { width: 20%; background: #10b981; }
        .stress-fill.medium { width: 60%; background: #f7931e; }
        .stress-fill.high { width: 90%; background: #ff4757; }

        .healing-card {
            background: rgba(0, 0, 0, 0.8);
            border: 2px solid rgba(144, 238, 144, 0.4);
            border-radius: 20px;
            padding: 30px;
            margin: 25px 0;
            position: relative;
            transition: all 0.3s ease;
            overflow: hidden;
            box-shadow: 
                0 15px 30px rgba(0, 0, 0, 0.4),
                inset 0 1px 0 rgba(255, 255, 255, 0.1);
        }

        /* Fundo espacial para healing-cards */
        .healing-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: 
                radial-gradient(circle at 30% 20%, rgba(74, 124, 42, 0.3) 0%, transparent 40%),
                radial-gradient(circle at 70% 80%, rgba(107, 154, 61, 0.2) 0%, transparent 40%),
                linear-gradient(135deg, 
                    rgba(26, 47, 15, 0.1) 0%, 
                    rgba(45, 80, 22, 0.1) 50%, 
                    rgba(74, 124, 42, 0.1) 100%);
            animation: backgroundFloat 10s ease-in-out infinite;
            pointer-events: none;
            border-radius: 20px;
            z-index: 0;
        }

        .healing-card > * {
            position: relative;
            z-index: 2;
        }

        /* Emoji de estrela para healing-cards */
        .healing-card .sparkle-emoji {
            position: absolute;
            top: 15px;
            right: 20px;
            font-size: 1.5rem;
            opacity: 0.7;
            animation: sparkle 2s ease-in-out infinite;
            z-index: 3;
        }

        @keyframes sparkle {
            0%, 100% { opacity: 0.3; transform: rotate(0deg) scale(1); }
            50% { opacity: 1; transform: rotate(180deg) scale(1.2); }
        }

        .healing-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 20px 40px rgba(144, 238, 144, 0.3);
            border-color: rgba(144, 238, 144, 0.8);
        }

        .pain-point {
            background: rgba(255, 71, 87, 0.1);
            border-left: 4px solid #ff4757;
            padding: 15px;
            border-radius: 5px;
            margin: 15px 0;
        }

        .solution {
            background: rgba(16, 185, 129, 0.1);
            border-left: 4px solid #10b981;
            padding: 15px;
            border-radius: 5px;
            margin: 15px 0;
        }

        .relief-meter {
            display: flex;
            align-items: center;
            gap: 10px;
            margin: 20px 0;
        }

        .relief-stars {
            display: flex;
            gap: 5px;
        }

        .relief-star {
            color: #fbbf24;
            font-size: 1.2rem;
            transition: all 0.3s ease;
        }

        .relief-star.active {
            text-shadow: 0 0 10px rgba(251, 191, 36, 0.8);
            animation: star-glow 1s ease-in-out infinite alternate;
        }

        @keyframes star-glow {
            from { transform: scale(1); }
            to { transform: scale(1.1); }
        }

        .therapy-section {
            background: rgba(139, 92, 246, 0.1);
            border-radius: 20px;
            padding: 30px;
            margin: 40px 0;
            text-align: center;
        }

        .meditation-guide {
            background: rgba(45, 80, 22, 0.6);
            border-radius: 15px;
            padding: 25px;
            margin: 25px 0;
            border: 1px solid rgba(144, 238, 144, 0.3);
            box-shadow: 0 10px 25px rgba(0,0,0,0.25), inset 0 1px 0 rgba(255,255,255,0.06);
            position: relative;
            overflow: hidden;
        }

        /* Orna o fundo com um brilho sutil */
        .meditation-guide::before {
            content: '';
            position: absolute;
            inset: 0;
            background: radial-gradient(circle at 30% 20%, rgba(144,238,144,0.12) 0%, transparent 45%),
                        radial-gradient(circle at 70% 80%, rgba(74,124,42,0.12) 0%, transparent 45%);
            pointer-events: none;
            z-index: 0;
        }

        .meditation-guide h4,
        .meditation-guide p,
        .meditation-guide ul,
        .meditation-guide li,
        .meditation-guide button {
            position: relative;
            z-index: 1;
        }

        /* Remove os bullets padrão e alinha melhor */
        .meditation-guide ul {
            list-style: none;
            margin: 15px 0 0 0;
            padding: 0;
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
            gap: 10px 20px;
        }

        .meditation-guide ul li {
            display: flex;
            align-items: flex-start;
            gap: 10px;
            padding: 10px 12px;
            border-radius: 10px;
            background: rgba(144, 238, 144, 0.08);
            border: 1px solid rgba(144, 238, 144, 0.18);
        }

        .meditation-guide ul li::before {
            content: '🧘';
            flex-shrink: 0;
            font-size: 1rem;
            line-height: 1.2;
            margin-top: 2px;
            filter: drop-shadow(0 0 6px rgba(144,238,144,0.5));
        }

        /* Variante compacta em telas menores */
        @media (max-width: 520px) {
            .meditation-guide ul {
                grid-template-columns: 1fr;
            }
        }

        .breathing-exercise {
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 30px 0;
        }

        .breath-circle {
            width: 150px;
            height: 150px;
            border: 3px solid #90ee90;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            animation: breath 4s ease-in-out infinite;
            background: radial-gradient(circle, rgba(144, 238, 144, 0.1), transparent);
        }

        @keyframes breath {
            0%, 100% { transform: scale(1); border-color: #90ee90; }
            50% { transform: scale(1.2); border-color: #10b981; }
        }

        .quick-fix {
            background: linear-gradient(135deg, #2d5016, #4a7c23);
            color: #90ee90;
            padding: 20px;
            border-radius: 15px;
            margin: 20px 0;
            border: 2px solid rgba(144, 238, 144, 0.4);
        }

        .quick-fix h4 {
            margin: 0 0 10px 0;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .emergency-kit {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
            gap: 20px;
            margin: 30px 0;
        }

        .kit-item {
            background: rgba(45, 80, 22, 0.8);
            border: 2px solid rgba(144, 238, 144, 0.3);
            border-radius: 15px;
            padding: 20px;
            text-align: center;
            transition: all 0.3s ease;
        }

        .kit-item:hover {
            transform: translateY(-3px);
            box-shadow: 0 10px 25px rgba(144, 238, 144, 0.2);
        }

        .kit-icon {
            font-size: 3rem;
            color: #90ee90;
            margin-bottom: 15px;
            text-shadow: 0 0 15px rgba(144, 238, 144, 0.5);
        }

        .mood-tracker {
            background: rgba(45, 80, 22, 0.6);
            border-radius: 15px;
            padding: 25px;
            margin: 30px 0;
        }

        .mood-options {
            display: flex;
            justify-content: space-around;
            margin: 20px 0;
        }

        .mood-emoji {
            font-size: 2rem;
            cursor: pointer;
            padding: 10px;
            border-radius: 50%;
            transition: all 0.3s ease;
        }

        .mood-emoji:hover {
            background: rgba(144, 238, 144, 0.2);
            transform: scale(1.2);
        }

        .news-therapy {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(400px, 1fr));
            gap: 30px;
            margin: 40px 0;
        }

        .therapy-card {
            background: rgba(0, 0, 0, 0.8);
            border: 2px solid rgba(144, 238, 144, 0.3);
            border-radius: 20px;
            padding: 30px;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
            box-shadow: 
                0 20px 40px rgba(0, 0, 0, 0.5),
                inset 0 1px 0 rgba(255, 255, 255, 0.1);
        }

        /* Fundo lindo como manual-articles-section */
        .therapy-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: 
                radial-gradient(circle at 20% 30%, rgba(74, 124, 42, 0.4) 0%, transparent 50%),
                radial-gradient(circle at 80% 70%, rgba(107, 154, 61, 0.3) 0%, transparent 50%),
                radial-gradient(circle at 40% 80%, rgba(143, 179, 102, 0.2) 0%, transparent 50%),
                linear-gradient(45deg, 
                    rgba(26, 47, 15, 0.1) 0%, 
                    rgba(45, 80, 22, 0.1) 25%, 
                    rgba(74, 124, 42, 0.1) 50%, 
                    rgba(107, 154, 61, 0.1) 75%, 
                    rgba(143, 179, 102, 0.1) 100%);
            animation: backgroundFloat 8s ease-in-out infinite;
            pointer-events: none;
            border-radius: 20px;
            z-index: 0;
        }

        /* Partículas flutuantes */
        .therapy-card::after {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-image: 
                radial-gradient(2px 2px at 20px 30px, rgba(144, 238, 144, 0.3), transparent),
                radial-gradient(2px 2px at 40px 70px, rgba(74, 124, 42, 0.4), transparent),
                radial-gradient(1px 1px at 90px 40px, rgba(107, 154, 61, 0.3), transparent),
                radial-gradient(1px 1px at 130px 80px, rgba(143, 179, 102, 0.4), transparent),
                radial-gradient(2px 2px at 160px 30px, rgba(144, 238, 144, 0.3), transparent),
                radial-gradient(1px 1px at 200px 60px, rgba(74, 124, 42, 0.4), transparent),
                radial-gradient(2px 2px at 240px 90px, rgba(107, 154, 61, 0.3), transparent),
                radial-gradient(1px 1px at 280px 20px, rgba(143, 179, 102, 0.4), transparent);
            animation: particleFloat 12s linear infinite;
            pointer-events: none;
            border-radius: 20px;
            z-index: 0;
        }

        /* Garantir que conteúdo fique acima */
        .therapy-card > * {
            position: relative;
            z-index: 2;
        }

        /* Emoji de coração */
        .therapy-card .heart-emoji {
            position: absolute;
            top: 20px;
            right: 20px;
            font-size: 1.5rem;
            animation: heartbeat 2s ease-in-out infinite;
            z-index: 3;
        }

        @keyframes heartbeat {
            0%, 100% { transform: scale(1); }
            50% { transform: scale(1.1); }
        }

        .therapy-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 35px rgba(144, 238, 144, 0.3);
        }

        .wellness-tip {
            background: linear-gradient(135deg, rgba(16, 185, 129, 0.1), rgba(139, 92, 246, 0.1));
            border-radius: 15px;
            padding: 20px;
            margin: 20px 0;
            border-left: 4px solid #10b981;
        }

        .wellness-tip h5 {
            color: #10b981;
            margin-bottom: 10px;
            display: flex;
            align-items: center;
            gap: 10px;
        }
    </style>
    
    <!-- Google Analytics -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-JBDJ3PPN93"></script>
    <script>
      window.dataLayer = window.dataLayer || [];
      function gtag(){dataLayer.push(arguments);}
      gtag('js', new Date());
      gtag('config', 'G-JBDJ3PPN93');
    </script>
</head>
<body class="psychedelic-mode">
    <!-- Preloader -->
    <div id="preloader">
        <div class="circuit-lines"></div>
        <div class="binary-text"></div>
        <div class="scan-line"></div>
        <div class="preloader-content">
            <div class="holo-container">
                <div class="rotating-ring"></div>
                <div class="rotating-ring"></div>
                <div class="rotating-ring"></div>
                <div class="tech-circle"></div>
                <div class="hex-spinner">
                    <div class="hex"></div>
                    <div class="hex"></div>
                    <div class="hex"></div>
                    <div class="hex"></div>
                    <div class="hex"></div>
                    <div class="hex"></div>
                </div>
                <div class="loading-bubbles">
                    <div class="bubble psychedelic"></div>
                    <div class="bubble psychedelic"></div>
                    <div class="bubble psychedelic"></div>
                    <div class="bubble psychedelic"></div>
                    <div class="bubble psychedelic"></div>
                    <div class="bubble psychedelic"></div>
                </div>
                <div class="neon-text">
                    <span class="glitch-text" data-text="NOTÍCIAS">NOTÍCIAS</span>
                    <div class="loading-dots">
                        <span></span><span></span><span></span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Botão Voltar ao Topo -->
    <div class="back-to-top">
        <i class="fas fa-arrow-up"></i>
    </div>

    <!-- Menu Lateral -->
    <div class="psychedelic-menu-container">
        <div class="menu-toggle">
            <div class="hamburger">
                <span></span>
                <span></span>
                <span></span>
            </div>
        </div>
        
        <nav class="side-menu">
            <div class="menu-background">
                <div class="liquid-shape"></div>
                <div class="fractal-pattern"></div>
                <div class="glow-particles"></div>
            </div>
            
            <div class="menu-content">
                <div class="menu-header">
                    <div class="menu-logo">
                        <h2>CyberNews</h2>
                    </div>
                </div>
                
                <ul class="menu-items">
                    <li class="menu-item">
                        <a href="<?php echo url(''); ?>" class="menu-link">
                            <i class="fas fa-home"></i>
                            <span>Início</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                    <li class="menu-item active">
                        <a href="<?php echo url('noticias'); ?>" class="menu-link">
                            <i class="fas fa-newspaper"></i>
                            <span>Notícias</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                    <li class="menu-item">
                        <a href="<?php echo url('seguranca'); ?>" class="menu-link">
                            <i class="fas fa-lock"></i>
                            <span>Segurança</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                    <li class="menu-item">
                        <a href="<?php echo url('vulnerabilidades'); ?>" class="menu-link">
                            <i class="fas fa-bug"></i>
                            <span>Vulnerabilidades</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                    <li class="menu-item">
                        <a href="<?php echo url('malware'); ?>" class="menu-link">
                            <i class="fas fa-virus"></i>
                            <span>Malware</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                    <li class="menu-item">
                        <a href="<?php echo url('privacidade'); ?>" class="menu-link">
                            <i class="fas fa-user-secret"></i>
                            <span>Privacidade</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                    <li class="menu-item">
                        <a href="<?php echo url('loja'); ?>" class="menu-link" aria-label="Loja">
                            <i class="fas fa-shopping-cart" aria-hidden="true"></i>
                            <span>Loja</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                    <li class="menu-item">
                        <a href="https://lucas.br.vc/" class="menu-link" target="_blank" aria-label="Contato">
                            <i class="fas fa-envelope" aria-hidden="true"></i>
                            <span>Contato</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                </ul>
                
                <div class="menu-footer">
                    <div class="social-icons">
                        <a href="#" class="social-icon"><i class="fab fa-twitter"></i></a>
                        <a href="#" class="social-icon"><i class="fab fa-github"></i></a>
                        <a href="#" class="social-icon"><i class="fab fa-linkedin"></i></a>
                    </div>
                    <div class="admin-menu-access">
                        <a href="<?php echo url('admin/'); ?>" class="admin-menu-btn" title="Painel Admin">
                            <i class="fas fa-cogs"></i>
                        </a>
                    </div>
                </div>
            </div>
        </nav>
    </div>

    <header>
        <div class="container" role="banner">
            <div class="logo" aria-label="CyberNews Logo">
                <h1 style="margin:0;">CyberNews</h1>
            </div>
            <nav aria-label="Navegação principal">
                <a href="<?php echo url(''); ?>" class="admin-btn" style="text-decoration:none;">
                    <i class="fas fa-home" aria-hidden="true"></i> Início
                </a>
            </nav>
        </div>
    </header>

    <main class="main-content" role="main">
        <div id="main-content">
            <div class="container">
                <!-- Hero Section Terapêutica -->
                <section class="store-hero" aria-labelledby="news-title">
                    <h1 id="news-title">💚 Notícias que Curam</h1>
                    <p>Transformamos o estresse da cibersegurança em tranquilidade. Aqui você encontra alívio, não mais dor de cabeça.</p>
                </section>

                <!-- Medidor de Estresse -->
                <section class="pain-relief-section">
                    <h2>🌡️ Como está seu nível de estresse hoje?</h2>
                    <div class="mood-tracker">
                        <h3>Escolha seu humor atual:</h3>
                        <div class="mood-options">
                            <div class="mood-emoji" onclick="setMood('zen')" title="Zen">🧘‍♂️</div>
                            <div class="mood-emoji" onclick="setMood('happy')" title="Feliz">😊</div>
                            <div class="mood-emoji" onclick="setMood('neutral')" title="Neutro">😐</div>
                            <div class="mood-emoji" onclick="setMood('worried')" title="Preocupado">😟</div>
                            <div class="mood-emoji" onclick="setMood('stressed')" title="Estressado">😫</div>
                        </div>
                        <div class="stress-meter">
                            <span>😌 Zen</span>
                            <div class="stress-level">
                                <div class="stress-fill medium" id="stress-indicator"></div>
                            </div>
                            <span>😵 Estresse</span>
                        </div>
                    </div>

                    <!-- Exercício de Respiração -->
                    <div class="therapy-section">
                        <h3>🫁 Exercício de Respiração Rápida</h3>
                        <p>Antes de ler as notícias, vamos aliviar o estresse:</p>
                        <div class="breathing-exercise">
                            <div class="breath-circle">
                                <span style="color: #90ee90; font-weight: bold;">RESPIRE</span>
                            </div>
                        </div>
                        <p><strong>Inspire por 4 segundos → Segure por 4 → Expire por 6</strong></p>
                    </div>
                </section>

                <!-- Kit de Emergência Anti-Estresse -->
                <section class="emergency-kit">
                    <div class="kit-item">
                        <div class="kit-icon">🆘</div>
                        <h4>SOS Rápido</h4>
                        <p>Problema urgente? Clique aqui para soluções em 2 minutos</p>
                        <button class="guide-btn" onclick="showQuickFix()">Resolver Agora</button>
                    </div>
                    
                    <div class="kit-item">
                        <div class="kit-icon">🧘‍♀️</div>
                        <h4>Pausa Zen</h4>
                        <p>5 minutos de meditação guiada para profissionais de TI</p>
                        <button class="guide-btn" onclick="startMeditation()">Iniciar</button>
                    </div>
                    
                    <div class="kit-item">
                        <div class="kit-icon">📚</div>
                        <h4>Explicação Simples</h4>
                        <p>Traduzimos jargões técnicos para linguagem humana</p>
                        <button class="guide-btn" onclick="showGlossary()">Ver Glossário</button>
                    </div>
                    
                    <div class="kit-item">
                        <div class="kit-icon">💡</div>
                        <h4>Solução Instantânea</h4>
                        <p>IA que resolve seus problemas de segurança em segundos</p>
                        <button class="guide-btn" onclick="openAI()">Perguntar IA</button>
                    </div>
                </section>

                <!-- Notícias Terapêuticas -->
                <section class="news-therapy">
                    <!-- Notícia 1 - Transformando Dor em Alívio -->
                    <article class="therapy-card">
                        <div class="heart-emoji">💚</div>
                        <h3>🌟 Boa Notícia: Microsoft Facilita Patches Automáticos</h3>
                        
                        <div class="pain-point">
                            <strong>😫 A Dor:</strong> "Sempre esqueço de aplicar patches e fico com medo de ataques."
                        </div>
                        
                        <div class="solution">
                            <strong>💚 O Alívio:</strong> Microsoft lançou sistema que aplica patches críticos automaticamente, sem intervenção manual. Sua empresa fica protegida enquanto você dorme!
                        </div>
                        
                        <div class="relief-meter">
                            <span>Alívio do Estresse:</span>
                            <div class="relief-stars">
                                <span class="relief-star active">★</span>
                                <span class="relief-star active">★</span>
                                <span class="relief-star active">★</span>
                                <span class="relief-star active">★</span>
                                <span class="relief-star">★</span>
                            </div>
                            <span>(4/5 estrelas)</span>
                        </div>
                        
                        <div class="wellness-tip">
                            <h5>💡 Dica de Bem-Estar:</h5>
                            <p>Configure agora e durma tranquilo sabendo que está protegido!</p>
                        </div>
                        
                        <div class="quick-fix">
                            <h4>⚡ Solução em 2 Minutos:</h4>
                            <ol>
                                <li>Abra Windows Update</li>
                                <li>Ative "Instalar automaticamente"</li>
                                <li>Defina horário fora do expediente</li>
                                <li>Relaxe! 🧘‍♂️</li>
                            </ol>
                        </div>
                    </article>

                    <!-- Notícia 2 - Solução Prática -->
                    <article class="therapy-card">
                        <div class="heart-emoji">💚</div>
                        <h3>🎯 Finalmente: Antivírus que NÃO Trava o PC</h3>
                        
                        <div class="pain-point">
                            <strong>😫 A Dor:</strong> "Meu antivírus deixa tudo lento, mas não posso desinstalar."
                        </div>
                        
                        <div class="solution">
                            <strong>💚 O Alívio:</strong> Nova geração de antivírus usa IA para ser 90% mais leve. Proteção máxima, velocidade mantida!
                        </div>
                        
                        <div class="relief-meter">
                            <span>Alívio do Estresse:</span>
                            <div class="relief-stars">
                                <span class="relief-star active">★</span>
                                <span class="relief-star active">★</span>
                                <span class="relief-star active">★</span>
                                <span class="relief-star active">★</span>
                                <span class="relief-star active">★</span>
                            </div>
                            <span>(5/5 estrelas)</span>
                        </div>
                        
                        <div class="wellness-tip">
                            <h5>🌿 Respire Fundo:</h5>
                            <p>Seus usuários vão parar de reclamar da lentidão!</p>
                        </div>
                        
                        <div class="quick-fix">
                            <h4>⚡ Teste Gratuito:</h4>
                            <p>Experimente por 30 dias sem compromisso. Se não melhorar a performance, dinheiro de volta!</p>
                            <button class="vpn-cta-btn">🚀 Testar Agora</button>
                        </div>
                    </article>

                    <!-- Notícia 3 - Educação Tranquila -->
                    <article class="therapy-card">
                        <div class="heart-emoji">💚</div>
                        <h3>📚 Curso: "Cibersegurança Sem Estresse"</h3>
                        
                        <div class="pain-point">
                            <strong>😫 A Dor:</strong> "Preciso me atualizar mas os cursos são muito técnicos e confusos."
                        </div>
                        
                        <div class="solution">
                            <strong>💚 O Alívio:</strong> Novo curso explica cibersegurança como se fosse para sua avó. Linguagem simples, exemplos práticos, zero jargões!
                        </div>
                        
                        <div class="relief-meter">
                            <span>Alívio do Estresse:</span>
                            <div class="relief-stars">
                                <span class="relief-star active">★</span>
                                <span class="relief-star active">★</span>
                                <span class="relief-star active">★</span>
                                <span class="relief-star active">★</span>
                                <span class="relief-star">★</span>
                            </div>
                            <span>(4/5 estrelas)</span>
                        </div>
                        
                        <div class="wellness-tip">
                            <h5>🎓 Aprendizado Zen:</h5>
                            <p>15 minutos por dia, no seu ritmo, sem pressão!</p>
                        </div>
                        
                        <div class="meditation-guide">
                            <h4>🧘‍♂️ Módulos Relaxantes:</h4>
                            <ul>
                                <li>• "Firewalls para Humanos Normais"</li>
                                <li>• "Senhas Seguras Sem Drama"</li>
                                <li>• "Backup: Durma Tranquilo"</li>
                                <li>• "Phishing: Como Não Cair na Pegadinha"</li>
                            </ul>
                        </div>
                    </article>

                    <!-- Notícia 4 - Comunidade de Apoio -->
                    <article class="therapy-card">
                        <div class="heart-emoji">💚</div>
                        <h3>🤝 Comunidade: "Admins Anônimos"</h3>
                        
                        <div class="pain-point">
                            <strong>😫 A Dor:</strong> "Me sinto sozinho lidando com problemas de segurança."
                        </div>
                        
                        <div class="solution">
                            <strong>💚 O Alívio:</strong> Grupo de apoio para profissionais de TI. Compartilhe suas dores, receba ajuda, faça amigos que te entendem!
                        </div>
                        
                        <div class="relief-meter">
                            <span>Alívio do Estresse:</span>
                            <div class="relief-stars">
                                <span class="relief-star active">★</span>
                                <span class="relief-star active">★</span>
                                <span class="relief-star active">★</span>
                                <span class="relief-star active">★</span>
                                <span class="relief-star active">★</span>
                            </div>
                            <span>(5/5 estrelas)</span>
                        </div>
                        
                        <div class="wellness-tip">
                            <h5>💬 Terapia em Grupo:</h5>
                            <p>"Problemas compartilhados são problemas pela metade"</p>
                        </div>
                        
                        <div class="quick-fix">
                            <h4>🌟 Benefícios Imediatos:</h4>
                            <ul>
                                <li>✅ Suporte 24/7 da comunidade</li>
                                <li>✅ Soluções testadas por pares</li>
                                <li>✅ Desabafos sem julgamento</li>
                                <li>✅ Networking com propósito</li>
                            </ul>
                            <button class="vpn-cta-btn">💬 Entrar na Comunidade</button>
                        </div>
                    </article>
                </section>

                <!-- Seção de Alívio Imediato -->
                <section class="pain-relief-section">
                    <h2>🩹 Primeiros Socorros Digitais</h2>
                    <p>Para quando você precisa de alívio AGORA:</p>
                    
                    <div class="emergency-kit">
                        <div class="healing-card">
                            <div class="sparkle-emoji">✨</div>
                            <h4>🚨 PC Infectado?</h4>
                            <p><strong>Respire fundo.</strong> Não é o fim do mundo.</p>
                            <ol>
                                <li>Desconecte da internet (cabo ou WiFi)</li>
                                <li>Não entre em pânico - isso acontece</li>
                                <li>Use nosso scanner gratuito</li>
                                <li>Siga as instruções passo-a-passo</li>
                            </ol>
                            <button class="guide-btn">🛡️ Scanner Gratuito</button>
                        </div>
                        
                        <div class="healing-card">
                            <div class="sparkle-emoji">✨</div>
                            <h4>📧 Email Suspeito?</h4>
                            <p><strong>Parabéns por desconfiar!</strong> Você já está sendo seguro.</p>
                            <ol>
                                <li>NÃO clique em nada</li>
                                <li>Encaminhe para nossa análise</li>
                                <li>Receba resposta em 5 minutos</li>
                                <li>Durma tranquilo sabendo a verdade</li>
                            </ol>
                            <button class="guide-btn">📧 Analisar Email</button>
                        </div>
                        
                        <div class="healing-card">
                            <div class="sparkle-emoji">✨</div>
                            <h4>🔒 Esqueceu a Senha?</h4>
                            <p><strong>Acontece com todo mundo.</strong> Vamos resolver juntos.</p>
                            <ol>
                                <li>Use nosso gerador de senhas seguras</li>
                                <li>Salve no gerenciador (gratuito)</li>
                                <li>Configure recuperação por SMS</li>
                                <li>Nunca mais se preocupe</li>
                            </ol>
                            <button class="guide-btn">🔑 Gerar Senha</button>
                        </div>
                    </div>
                </section>

                <!-- Seção de Bem-Estar Digital -->
                <section class="therapy-section">
                    <h2>🌱 Jardim Digital do Bem-Estar</h2>
                    <p>Cultive uma relação saudável com a tecnologia:</p>
                    
                    <div class="wellness-tip">
                        <h5>🌸 Mantra do Admin Zen:</h5>
                        <p><em>"Nem todo problema é urgente. Nem toda urgência é problema. Respiro, analiso, resolvo."</em></p>
                    </div>
                    
                    <div class="meditation-guide">
                        <h4>🧘‍♂️ Meditação de 5 Minutos para Admins</h4>
                        <p>Feche os olhos, respire fundo e repita:</p>
                        <ul>
                            <li>• "Meus sistemas estão seguros"</li>
                            <li>• "Tenho controle sobre a situação"</li>
                            <li>• "Problemas têm soluções"</li>
                            <li>• "Sou competente e preparado"</li>
                            <li>• "Mereço paz e tranquilidade"</li>
                        </ul>
                        <button class="guide-btn" onclick="playMeditation()">🎵 Áudio Guiado</button>
                    </div>
                </section>

                <!-- Footer Motivacional -->
                <section class="pain-relief-section">
                    <h2>💝 Lembre-se sempre:</h2>
                    <div style="text-align: center; font-size: 1.2rem; line-height: 1.8;">
                        <p>🌟 <strong>Você não está sozinho</strong> - milhares de profissionais passam pelos mesmos desafios</p>
                        <p>🛡️ <strong>Você é competente</strong> - cada problema resolvido te torna mais forte</p>
                        <p>🌱 <strong>Está tudo bem não saber tudo</strong> - aprendemos todos os dias</p>
                        <p>💚 <strong>Sua saúde mental importa</strong> - cuide de si mesmo primeiro</p>
                        <p>🌈 <strong>Amanhã será um dia melhor</strong> - problemas passam, você permanece</p>
                    </div>
                    
                    <div style="text-align: center; margin-top: 30px;">
                        <button class="vpn-cta-btn premium" onclick="showAppreciation()">
                            🤗 Preciso de um Abraço Digital
                        </button>
                    </div>
                </section>
            </div>
        </div>
    </main>

    <footer>
        <div class="container">
            <div class="footer-content">
                <div class="footer-logo">
                    <h2>CyberNews</h2>
                </div>
                <p>Transformando estresse em tranquilidade, um artigo de cada vez. 💚</p>
            </div>
            <div class="copyright">
                <p>&copy; <?= date('Y') ?> CyberNews - Cuidando da sua saúde digital.</p>
            </div>
        </div>
    </footer>

    <script>
        // Funcionalidades terapêuticas
        function setMood(mood) {
            const stressIndicator = document.getElementById('stress-indicator');
            const moods = {
                'zen': { class: 'low', message: 'Que bom! Continue assim! 🧘‍♂️' },
                'happy': { class: 'low', message: 'Excelente! Você está equilibrado! 😊' },
                'neutral': { class: 'medium', message: 'Normal. Que tal um exercício de respiração? 😐' },
                'worried': { class: 'high', message: 'Vamos aliviar essa preocupação juntos! 😟' },
                'stressed': { class: 'high', message: 'Respire fundo. Você vai superar isso! 😫' }
            };
            
            if (moods[mood]) {
                stressIndicator.className = 'stress-fill ' + moods[mood].class;
                alert(moods[mood].message);
                
                if (mood === 'worried' || mood === 'stressed') {
                    startMeditation();
                }
            }
        }

        function showQuickFix() {
            alert('🆘 SOS Ativado!\n\n1. Respire fundo (3x)\n2. Descreva o problema em uma frase\n3. Procure na nossa base de soluções\n4. Se não encontrar, chame ajuda\n\nVocê não está sozinho! 💪');
        }

        function startMeditation() {
            alert('🧘‍♀️ Iniciando Meditação...\n\nFeche os olhos e respire:\n\n👃 Inspire por 4 segundos\n⏸️ Segure por 4 segundos\n👄 Expire por 6 segundos\n\nRepita 5 vezes. Você consegue! 🌸');
        }

        function showGlossary() {
            alert('📚 Tradutor Técnico:\n\n• Firewall = Porteiro digital\n• Malware = Programa malvado\n• Phishing = Pegadinha por email\n• VPN = Túnel secreto na internet\n• Backup = Cópia de segurança\n\nSimples assim! 😊');
        }

        function openAI() {
            alert('🤖 IA Terapêutica Ativada!\n\n"Olá! Sou sua assistente de bem-estar digital.\nConte-me seu problema e eu te ajudo com:\n\n✅ Solução técnica\n✅ Alívio do estresse\n✅ Próximos passos\n✅ Palavras de encorajamento\n\nO que está te preocupando hoje?"');
        }

        function playMeditation() {
            alert('🎵 Áudio de Meditação Iniciado...\n\n"Respire fundo... Você é capaz... Seus sistemas estão seguros... Você tem controle... Problemas passam, você permanece..."\n\n🌟 Continue respirando calmamente por mais alguns minutos.');
        }

        function showAppreciation() {
            const messages = [
                '🤗 Abraço digital enviado! Você é incrível!',
                '💚 Você está fazendo um ótimo trabalho!',
                '🌟 Lembre-se: você é mais forte do que pensa!',
                '🦋 Respire fundo. Amanhã será melhor!',
                '🌈 Você não está sozinho nessa jornada!'
            ];
            
            const randomMessage = messages[Math.floor(Math.random() * messages.length)];
            alert(randomMessage + '\n\n🫂 Sempre que precisar, estaremos aqui para você!');
        }

        // Animação automática do círculo de respiração
        setInterval(() => {
            const breathText = document.querySelector('.breath-circle span');
            if (breathText) {
                setTimeout(() => breathText.textContent = 'INSPIRE', 0);
                setTimeout(() => breathText.textContent = 'SEGURE', 2000);
                setTimeout(() => breathText.textContent = 'EXPIRE', 4000);
                setTimeout(() => breathText.textContent = 'RESPIRE', 6000);
            }
        }, 8000);
    </script>
    
    <script src="<?php echo asset('js/performance.js'); ?>" defer></script>
    <script src="<?php echo asset('js/modals.js'); ?>" defer></script>
    <script src="<?php echo asset('script.js'); ?>" defer></script>
</body>
</html>
