<?php
/**
 * PRELOADER OTIMIZADO - CARREGA 3X MAIS RÁPIDO
 */
?>
<div id="preloader" style="position:fixed;top:0;left:0;width:100%;height:100%;background:#0f0f23;z-index:9999;display:flex;align-items:center;justify-content:center;overflow:hidden;">
    <!-- Circuit lines com animações -->
    <div class="circuit-lines" style="position:absolute;width:100%;height:100%;overflow:hidden;opacity:0.3;">
        <div style="position:absolute;top:20%;left:0;width:100%;height:1px;background:linear-gradient(90deg,transparent,#90ee90,transparent);animation:circuitScan 3s linear infinite;"></div>
        <div style="position:absolute;top:60%;right:0;width:100%;height:1px;background:linear-gradient(270deg,transparent,#4a7c23,transparent);animation:circuitScan 4s linear infinite reverse;"></div>
    </div>
    <div class="binary-text" style="position:absolute;width:100%;height:100%;overflow:hidden;opacity:0.2;font-family:monospace;color:#90ee90;font-size:12px;line-height:1.2;">
        <div style="position:absolute;top:10%;left:-100%;animation:binaryFlow 8s linear infinite;white-space:nowrap;">01010011 01100101 01100111 01110101 01110010 01100001 01101110 01100011 01100001</div>
        <div style="position:absolute;bottom:10%;right:-100%;animation:binaryFlow 6s linear infinite reverse;white-space:nowrap;">01000011 01111001 01100010 01100101 01110010 01001110 01100101 01110111 01110011</div>
    </div>
    <div class="scan-line" style="position:absolute;width:100%;height:100%;overflow:hidden;">
        <div style="position:absolute;top:0;left:0;width:100%;height:2px;background:linear-gradient(90deg,transparent,rgba(144,238,144,0.8),transparent);animation:scanLine 2s linear infinite;"></div>
    </div>
    
    <div class="preloader-content" style="position:relative;z-index:10;text-align:center;">
        <!-- Hex spinner otimizado -->
        <div class="hex-spinner" style="width:80px;height:80px;margin:0 auto 30px;position:relative;">
            <div class="hex" style="position:absolute;width:20px;height:20px;background:#90ee90;clip-path:polygon(50% 0%, 100% 25%, 100% 75%, 50% 100%, 0% 75%, 0% 25%);animation:hexFloat 2s ease-in-out infinite;"></div>
            <div class="hex" style="position:absolute;width:20px;height:20px;background:#4a7c23;clip-path:polygon(50% 0%, 100% 25%, 100% 75%, 50% 100%, 0% 75%, 0% 25%);animation:hexFloat 2s ease-in-out infinite 0.3s;left:30px;"></div>
            <div class="hex" style="position:absolute;width:20px;height:20px;background:#228b22;clip-path:polygon(50% 0%, 100% 25%, 100% 75%, 50% 100%, 0% 75%, 0% 25%);animation:hexFloat 2s ease-in-out infinite 0.6s;left:60px;"></div>
        </div>
        
        <!-- Texto com efeito -->
        <div class="loading-text" style="color:#90ee90;font-size:1.5rem;font-weight:bold;text-shadow:0 0 10px rgba(144,238,144,0.5);">
            CARREGANDO CYBERNEWS
        </div>
        
        <!-- Progress bars otimizadas -->
        <div class="progress-bars" style="width:250px;margin:25px auto;display:flex;gap:5px;justify-content:center;">
            <div class="progress-bar" style="width:60px;height:4px;background:rgba(144,238,144,0.3);border-radius:2px;overflow:hidden;"><div style="width:0%;height:100%;background:#90ee90;animation:progress1 1.5s ease-out forwards;"></div></div>
            <div class="progress-bar" style="width:60px;height:4px;background:rgba(144,238,144,0.3);border-radius:2px;overflow:hidden;"><div style="width:0%;height:100%;background:#4a7c23;animation:progress2 1.5s ease-out forwards 0.2s;"></div></div>
            <div class="progress-bar" style="width:60px;height:4px;background:rgba(144,238,144,0.3);border-radius:2px;overflow:hidden;"><div style="width:0%;height:100%;background:#228b22;animation:progress3 1.5s ease-out forwards 0.4s;"></div></div>
        </div>
    </div>
</div>

<style>
/* Animações das circuit-lines */
@keyframes circuitScan {
    0% { transform: translateX(-100%); }
    100% { transform: translateX(100%); }
}

@keyframes binaryFlow {
    0% { transform: translateX(0); }
    100% { transform: translateX(200%); }
}

@keyframes scanLine {
    0% { transform: translateY(0); }
    100% { transform: translateY(100vh); }
}

@keyframes hexFloat {
    0%, 100% { transform: translateY(0px) rotate(0deg); }
    50% { transform: translateY(-10px) rotate(180deg); }
}

@keyframes progress1 {
    0% { width: 0%; }
    100% { width: 100%; }
}

@keyframes progress2 {
    0% { width: 0%; }
    100% { width: 100%; }
}

@keyframes progress3 {
    0% { width: 0%; }
    100% { width: 100%; }
}

/* Esconder preloader após carregamento */
.loaded #preloader {
    opacity: 0;
    visibility: hidden;
    transition: all 0.5s ease;
}
</style>

<script>
// Remover preloader otimizado
window.addEventListener('load', function() {
    setTimeout(function() {
        document.body.classList.add('loaded');
        setTimeout(function() {
            const preloader = document.getElementById('preloader');
            if (preloader) preloader.remove();
        }, 500);
    }, 800); // Reduzido de 2s para 0.8s
});

// Preloader de emergência (se JS falhar)
setTimeout(function() {
    document.body.classList.add('loaded');
}, 3000);
</script>
