<?php
header('Content-Type: text/html; charset=utf-8');
date_default_timezone_set('America/Sao_Paulo');
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Privacidade Digital | CyberNews</title>
    <meta name="description" content="Proteja sua privacidade online com as melhores VPNs, ferramentas de segurança e dicas de anonimato digital.">
    <meta name="robots" content="index,follow">
    <link rel="canonical" href="<?php echo url('privacidade'); ?>">

    <!-- Open Graph -->
    <meta property="og:title" content="Privacidade Digital - CyberNews">
    <meta property="og:description" content="Guias, ferramentas e VPNs para proteger sua privacidade online.">
    <meta property="og:type" content="website">
    <meta property="og:url" content="/privacidade">
    <meta property="og:site_name" content="CyberNews">

    <link rel="stylesheet" href="<?php echo asset('styles.css'); ?>">
    <link rel="stylesheet" href="<?php echo asset('css/news-psychedelic.css'); ?>">
    <link rel="stylesheet" href="<?php echo asset('css/sections.css'); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
    
    <!-- Google Analytics -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-JBDJ3PPN93"></script>
    <script>
      window.dataLayer = window.dataLayer || [];
      function gtag(){dataLayer.push(arguments);}
      gtag('js', new Date());
      gtag('config', 'G-JBDJ3PPN93');
    </script>
</head>
<body class="psychedelic-mode">
    <!-- Preloader Psicodélico -->
    <div id="preloader">
        <div class="circuit-lines"></div>
        <div class="binary-text"></div>
        <div class="scan-line"></div>
        <div class="preloader-content">
            <div class="holo-container">
                <div class="rotating-ring"></div>
                <div class="rotating-ring"></div>
                <div class="rotating-ring"></div>
                <div class="tech-circle"></div>
                <div class="hex-spinner">
                    <div class="hex"></div>
                    <div class="hex"></div>
                    <div class="hex"></div>
                    <div class="hex"></div>
                    <div class="hex"></div>
                    <div class="hex"></div>
                </div>
                <div class="loading-bubbles">
                    <div class="bubble psychedelic"></div>
                    <div class="bubble psychedelic"></div>
                    <div class="bubble psychedelic"></div>
                    <div class="bubble psychedelic"></div>
                    <div class="bubble psychedelic"></div>
                    <div class="bubble psychedelic"></div>
                </div>
                <div class="neon-text">
                    <span class="glitch-text" data-text="PRIVACIDADE">PRIVACIDADE</span>
                    <div class="loading-dots">
                        <span></span><span></span><span></span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Botão Voltar ao Topo -->
    <div class="back-to-top">
        <i class="fas fa-arrow-up"></i>
    </div>

    <!-- Menu Lateral Alucinado -->
    <div class="psychedelic-menu-container">
        <div class="menu-toggle">
            <div class="hamburger">
                <span></span>
                <span></span>
                <span></span>
            </div>
        </div>
        
        <nav class="side-menu">
            <div class="menu-background">
                <div class="liquid-shape"></div>
                <div class="fractal-pattern"></div>
                <div class="glow-particles"></div>
            </div>
            
            <div class="menu-content">
                <div class="menu-header">
                    <div class="menu-logo">
                        <h2>CyberNews</h2>
                    </div>
                </div>
                
                <ul class="menu-items">
                    <li class="menu-item">
                        <a href="<?php echo url(''); ?>" class="menu-link">
                            <i class="fas fa-home"></i>
                            <span>Início</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                    <li class="menu-item">
                        <a href="<?php echo url('noticias'); ?>" class="menu-link">
                            <i class="fas fa-newspaper"></i>
                            <span>Notícias</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                    <li class="menu-item">
                        <a href="<?php echo url('seguranca'); ?>" class="menu-link">
                            <i class="fas fa-lock"></i>
                            <span>Segurança</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                    <li class="menu-item">
                        <a href="<?php echo url('vulnerabilidades'); ?>" class="menu-link">
                            <i class="fas fa-bug"></i>
                            <span>Vulnerabilidades</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                    <li class="menu-item">
                        <a href="<?php echo url('malware'); ?>" class="menu-link">
                            <i class="fas fa-virus"></i>
                            <span>Malware</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                    <li class="menu-item active">
                        <a href="<?php echo url('privacidade'); ?>" class="menu-link">
                            <i class="fas fa-user-secret"></i>
                            <span>Privacidade</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                    <li class="menu-item">
                        <a href="<?php echo url('loja'); ?>" class="menu-link" aria-label="Loja">
                            <i class="fas fa-shopping-cart" aria-hidden="true"></i>
                            <span>Loja</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                    <li class="menu-item">
                        <a href="https://lucas.br.vc/" class="menu-link" target="_blank" aria-label="Contato">
                            <i class="fas fa-envelope" aria-hidden="true"></i>
                            <span>Contato</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                </ul>
                
                <div class="menu-footer">
                    <div class="social-icons">
                        <a href="#" class="social-icon"><i class="fab fa-twitter"></i></a>
                        <a href="#" class="social-icon"><i class="fab fa-github"></i></a>
                        <a href="#" class="social-icon"><i class="fab fa-linkedin"></i></a>
                    </div>
                    <div class="admin-menu-access">
                        <a href="<?php echo url('admin/'); ?>" class="admin-menu-btn" title="Painel Admin">
                            <i class="fas fa-cogs"></i>
                        </a>
                    </div>
                </div>
            </div>
        </nav>
    </div>

    <header>
        <div class="container" role="banner">
            <div class="logo" aria-label="CyberNews Logo">
                <h1 style="margin:0;">CyberNews</h1>
            </div>
            <nav aria-label="Navegação principal">
                <a href="<?php echo url(''); ?>" class="admin-btn" style="text-decoration:none;">
                    <i class="fas fa-home" aria-hidden="true"></i> Início
                </a>
            </nav>
        </div>
    </header>

    <main class="main-content" role="main">
        <div id="main-content">
            <div class="container">
                <section class="store-hero" aria-labelledby="privacy-title">
                    <h1 id="privacy-title">🔒 Privacidade Digital</h1>
                    <p>Proteja sua identidade online com as melhores ferramentas de privacidade e VPNs do mercado.</p>
                </section>

                <!-- Seção VPN Afiliados Premium -->
                <section class="vpn-affiliate-section" aria-label="VPNs Recomendadas">
                    <div class="section-header">
                        <h2>🌿 VPNs Premium Recomendadas</h2>
                        <p>Navegue anonimamente com as VPNs mais confiáveis do mercado</p>
                    </div>
                    
                    <div class="vpn-grid">
                        <!-- VPN 1 - NordVPN -->
                        <article class="vpn-card premium" role="article" aria-labelledby="nord-title" aria-describedby="nord-desc">
                            <div class="vpn-badge">🏆 MAIS POPULAR</div>
                            <div class="vpn-icon">
                                <i class="fas fa-shield-alt" aria-hidden="true"></i>
                            </div>
                            <h3 id="nord-title">NordVPN</h3>
                            <p id="nord-desc">A VPN mais confiável do mundo com criptografia militar e política de zero logs.</p>
                            <ul class="vpn-features">
                                <li>✅ 5.500+ servidores em 60 países</li>
                                <li>✅ Criptografia AES-256</li>
                                <li>✅ Kill Switch automático</li>
                                <li>✅ Sem logs de atividade</li>
                                <li>✅ Proteção contra malware</li>
                                <li>✅ 6 dispositivos simultâneos</li>
                            </ul>
                            <div class="vpn-pricing">
                                <div class="original-price">R$ 32,99/mês</div>
                                <div class="promo-price">R$ 12,99/mês</div>
                                <div class="discount-badge">60% OFF</div>
                            </div>
                            <div class="promo-code-container">
                                <span class="promo-label">Código Exclusivo:</span>
                                <div class="promo-code" onclick="copyPromoCode('CYBERNORD60')">
                                    <span>CYBERNORD60</span>
                                    <i class="fas fa-copy"></i>
                                </div>
                            </div>
                            <a href="#" class="vpn-cta-btn premium" target="_blank" rel="noopener">
                                🌿 ATIVAR NORDVPN
                                <i class="fas fa-arrow-right"></i>
                            </a>
                        </article>

                        <!-- VPN 2 - ExpressVPN -->
                        <article class="vpn-card" role="article" aria-labelledby="express-title" aria-describedby="express-desc">
                            <div class="vpn-icon">
                                <i class="fas fa-rocket" aria-hidden="true"></i>
                            </div>
                            <h3 id="express-title">ExpressVPN</h3>
                            <p id="express-desc">Velocidade ultra-rápida e segurança máxima para streaming e navegação.</p>
                            <ul class="vpn-features">
                                <li>✅ 3.000+ servidores em 94 países</li>
                                <li>✅ Velocidade ultra-rápida</li>
                                <li>✅ Criptografia de nível militar</li>
                                <li>✅ Política rigorosa de zero logs</li>
                                <li>✅ Suporte 24/7</li>
                                <li>✅ 5 dispositivos simultâneos</li>
                            </ul>
                            <div class="vpn-pricing">
                                <div class="original-price">R$ 42,99/mês</div>
                                <div class="promo-price">R$ 19,99/mês</div>
                                <div class="discount-badge">53% OFF</div>
                            </div>
                            <div class="promo-code-container">
                                <span class="promo-label">Código Exclusivo:</span>
                                <div class="promo-code" onclick="copyPromoCode('CYBEREXPRESS')">
                                    <span>CYBEREXPRESS</span>
                                    <i class="fas fa-copy"></i>
                                </div>
                            </div>
                            <a href="#" class="vpn-cta-btn" target="_blank" rel="noopener">
                                🚀 ATIVAR EXPRESSVPN
                                <i class="fas fa-arrow-right"></i>
                            </a>
                        </article>

                        <!-- VPN 3 - Surfshark -->
                        <article class="vpn-card budget" role="article" aria-labelledby="surf-title" aria-describedby="surf-desc">
                            <div class="vpn-badge budget">💰 MELHOR CUSTO</div>
                            <div class="vpn-icon">
                                <i class="fas fa-fish" aria-hidden="true"></i>
                            </div>
                            <h3 id="surf-title">Surfshark VPN</h3>
                            <p id="surf-desc">Excelente custo-benefício com dispositivos ilimitados e recursos avançados.</p>
                            <ul class="vpn-features">
                                <li>✅ 3.200+ servidores em 65 países</li>
                                <li>✅ Dispositivos ILIMITADOS</li>
                                <li>✅ CleanWeb (bloqueador de ads)</li>
                                <li>✅ MultiHop (VPN dupla)</li>
                                <li>✅ Modo camuflagem</li>
                                <li>✅ Garantia de 30 dias</li>
                            </ul>
                            <div class="vpn-pricing">
                                <div class="original-price">R$ 29,99/mês</div>
                                <div class="promo-price">R$ 8,99/mês</div>
                                <div class="discount-badge">70% OFF</div>
                            </div>
                            <div class="promo-code-container">
                                <span class="promo-label">Código Exclusivo:</span>
                                <div class="promo-code" onclick="copyPromoCode('CYBERSURF70')">
                                    <span>CYBERSURF70</span>
                                    <i class="fas fa-copy"></i>
                                </div>
                            </div>
                            <a href="#" class="vpn-cta-btn budget" target="_blank" rel="noopener">
                                💰 ATIVAR SURFSHARK
                                <i class="fas fa-arrow-right"></i>
                            </a>
                        </article>

                        <!-- VPN 4 - ProtonVPN -->
                        <article class="vpn-card security" role="article" aria-labelledby="proton-title" aria-describedby="proton-desc">
                            <div class="vpn-badge security">🔐 MÁXIMA SEGURANÇA</div>
                            <div class="vpn-icon">
                                <i class="fas fa-atom" aria-hidden="true"></i>
                            </div>
                            <h3 id="proton-title">ProtonVPN</h3>
                            <p id="proton-desc">VPN suíça com foco extremo em privacidade e segurança, criada pelos desenvolvedores do ProtonMail.</p>
                            <ul class="vpn-features">
                                <li>✅ Baseada na Suíça (leis rigorosas)</li>
                                <li>✅ Arquitetura Secure Core</li>
                                <li>✅ Tor over VPN integrado</li>
                                <li>✅ Auditoria independente</li>
                                <li>✅ Código aberto</li>
                                <li>✅ 10 dispositivos simultâneos</li>
                            </ul>
                            <div class="vpn-pricing">
                                <div class="original-price">R$ 24,99/mês</div>
                                <div class="promo-price">R$ 11,99/mês</div>
                                <div class="discount-badge">52% OFF</div>
                            </div>
                            <div class="promo-code-container">
                                <span class="promo-label">Código Exclusivo:</span>
                                <div class="promo-code" onclick="copyPromoCode('CYBERPROTON')">
                                    <span>CYBERPROTON</span>
                                    <i class="fas fa-copy"></i>
                                </div>
                            </div>
                            <a href="#" class="vpn-cta-btn security" target="_blank" rel="noopener">
                                🔐 ATIVAR PROTONVPN
                                <i class="fas fa-arrow-right"></i>
                            </a>
                        </article>
                    </div>

                    <div class="vpn-comparison">
                        <h3>📊 Comparação Rápida</h3>
                        <div class="comparison-table">
                            <table>
                                <thead>
                                    <tr>
                                        <th>VPN</th>
                                        <th>Preço/mês</th>
                                        <th>Servidores</th>
                                        <th>Dispositivos</th>
                                        <th>Melhor para</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td><strong>NordVPN</strong></td>
                                        <td>R$ 12,99</td>
                                        <td>5.500+</td>
                                        <td>6</td>
                                        <td>Uso geral</td>
                                    </tr>
                                    <tr>
                                        <td><strong>ExpressVPN</strong></td>
                                        <td>R$ 19,99</td>
                                        <td>3.000+</td>
                                        <td>5</td>
                                        <td>Streaming</td>
                                    </tr>
                                    <tr>
                                        <td><strong>Surfshark</strong></td>
                                        <td>R$ 8,99</td>
                                        <td>3.200+</td>
                                        <td>Ilimitados</td>
                                        <td>Famílias</td>
                                    </tr>
                                    <tr>
                                        <td><strong>ProtonVPN</strong></td>
                                        <td>R$ 11,99</td>
                                        <td>1.900+</td>
                                        <td>10</td>
                                        <td>Máxima privacidade</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </section>

                <!-- Seção Guias de Privacidade -->
                <section class="privacy-guides" aria-label="Guias de Privacidade">
                    <div class="section-header">
                        <h2>📚 Guias de Privacidade Digital</h2>
                        <p>Aprenda a proteger sua privacidade online com nossos guias completos</p>
                    </div>
                    
                    <div class="guides-grid">
                        <article class="guide-card">
                            <div class="guide-icon">
                                <i class="fas fa-eye-slash"></i>
                            </div>
                            <h3>Navegação Anônima</h3>
                            <p>Como navegar na internet sem deixar rastros digitais.</p>
                            <ul>
                                <li>• Configuração do Tor Browser</li>
                                <li>• VPNs + Tor (Double VPN)</li>
                                <li>• Motores de busca privados</li>
                                <li>• Limpeza de cookies e cache</li>
                            </ul>
                            <a href="#" class="guide-btn">📖 Ler Guia</a>
                        </article>

                        <article class="guide-card">
                            <div class="guide-icon">
                                <i class="fas fa-mobile-alt"></i>
                            </div>
                            <h3>Privacidade Mobile</h3>
                            <p>Proteja seus dados pessoais em smartphones e tablets.</p>
                            <ul>
                                <li>• Configurações de privacidade iOS/Android</li>
                                <li>• Apps seguros de mensagens</li>
                                <li>• Gerenciamento de permissões</li>
                                <li>• VPNs para dispositivos móveis</li>
                            </ul>
                            <a href="#" class="guide-btn">📱 Ler Guia</a>
                        </article>

                        <article class="guide-card">
                            <div class="guide-icon">
                                <i class="fas fa-envelope-open-text"></i>
                            </div>
                            <h3>Email Seguro</h3>
                            <p>Comunicações criptografadas e provedores seguros.</p>
                            <ul>
                                <li>• ProtonMail vs Tutanota</li>
                                <li>• Criptografia PGP</li>
                                <li>• Emails temporários</li>
                                <li>• Proteção contra phishing</li>
                            </ul>
                            <a href="#" class="guide-btn">📧 Ler Guia</a>
                        </article>

                        <article class="guide-card">
                            <div class="guide-icon">
                                <i class="fas fa-coins"></i>
                            </div>
                            <h3>Criptomoedas Privadas</h3>
                            <p>Transações financeiras anônimas e seguras.</p>
                            <ul>
                                <li>• Monero e Zcash</li>
                                <li>• Carteiras privadas</li>
                                <li>• Mixing services</li>
                                <li>• DEXs descentralizadas</li>
                            </ul>
                            <a href="#" class="guide-btn">💰 Ler Guia</a>
                        </article>
                    </div>
                </section>

                <!-- Seção Ferramentas de Privacidade -->
                <section class="privacy-tools" aria-label="Ferramentas de Privacidade">
                    <div class="section-header">
                        <h2>🛠️ Ferramentas Essenciais</h2>
                        <p>Software e aplicativos para maximizar sua privacidade</p>
                    </div>
                    
                    <div class="tools-categories">
                        <div class="tool-category">
                            <h3>🌐 Navegadores Privados</h3>
                            <div class="tool-list">
                                <div class="tool-item">
                                    <strong>Tor Browser</strong>
                                    <p>Navegação completamente anônima através da rede Tor</p>
                                    <a href="#" class="tool-link">Download</a>
                                </div>
                                <div class="tool-item">
                                    <strong>Brave Browser</strong>
                                    <p>Bloqueador de ads nativo e proteção contra rastreamento</p>
                                    <a href="#" class="tool-link">Download</a>
                                </div>
                                <div class="tool-item">
                                    <strong>Firefox + uBlock Origin</strong>
                                    <p>Firefox configurado para máxima privacidade</p>
                                    <a href="#" class="tool-link">Configurar</a>
                                </div>
                            </div>
                        </div>

                        <div class="tool-category">
                            <h3>💬 Mensagens Seguras</h3>
                            <div class="tool-list">
                                <div class="tool-item">
                                    <strong>Signal</strong>
                                    <p>Mensagens com criptografia ponta-a-ponta</p>
                                    <a href="#" class="tool-link">Download</a>
                                </div>
                                <div class="tool-item">
                                    <strong>Element (Matrix)</strong>
                                    <p>Comunicação descentralizada e criptografada</p>
                                    <a href="#" class="tool-link">Download</a>
                                </div>
                                <div class="tool-item">
                                    <strong>Session</strong>
                                    <p>Mensagens anônimas sem número de telefone</p>
                                    <a href="#" class="tool-link">Download</a>
                                </div>
                            </div>
                        </div>

                        <div class="tool-category">
                            <h3>🔐 Gerenciadores de Senha</h3>
                            <div class="tool-list">
                                <div class="tool-item">
                                    <strong>Bitwarden</strong>
                                    <p>Código aberto e auditado independentemente</p>
                                    <a href="#" class="tool-link">Começar</a>
                                </div>
                                <div class="tool-item">
                                    <strong>KeePassXC</strong>
                                    <p>Totalmente offline e criptografado localmente</p>
                                    <a href="#" class="tool-link">Download</a>
                                </div>
                                <div class="tool-item">
                                    <strong>1Password</strong>
                                    <p>Interface amigável com recursos avançados</p>
                                    <a href="#" class="tool-link">Experimentar</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>

                <!-- Footer com disclaimer -->
                <section class="affiliate-disclaimer">
                    <div class="disclaimer-content">
                        <h4>🤝 Transparência de Afiliados</h4>
                        <p>Este site contém links afiliados. Quando você compra através dos nossos links, recebemos uma pequena comissão sem custo adicional para você. Isso nos ajuda a manter o site funcionando e a produzir conteúdo de qualidade sobre cibersegurança.</p>
                        <p><strong>Importante:</strong> Recomendamos apenas produtos que testamos e confiamos. Nossas análises são imparciais e baseadas em testes reais.</p>
                    </div>
                </section>
            </div>
        </div>
    </main>

    <footer>
        <div class="container">
            <div class="footer-content">
                <div class="footer-logo">
                    <h2>CyberNews</h2>
                </div>
                <p>Sua privacidade digital em primeiro lugar.</p>
            </div>
            <div class="copyright">
                <p>&copy; <?= date('Y') ?> CyberNews - Todos os direitos reservados.</p>
            </div>
        </div>
    </footer>

    <script>
        function copyPromoCode(code) {
            navigator.clipboard.writeText(code).then(function() {
                // Feedback visual
                const button = event.currentTarget;
                const originalText = button.innerHTML;
                button.innerHTML = '<span>✅ COPIADO!</span><i class="fas fa-check"></i>';
                button.style.background = 'linear-gradient(135deg, #4a7c23, #90ee90)';
                
                setTimeout(() => {
                    button.innerHTML = originalText;
                    button.style.background = '';
                }, 2000);
            });
        }
    </script>
    
    <script src="<?php echo asset('js/performance.js'); ?>" defer></script>
    <script>
        // Teste direto - verificar se modals.js carrega
        console.log('🔍 Testando carregamento de modals.js...');
        
        // Criar função de teste simples
        function testModal() {
            console.log('🧪 Função de teste chamada!');
            
            // Remover modal anterior se existir
            const existingModal = document.querySelector('.modal-overlay');
            if (existingModal) {
                existingModal.remove();
            }
            
            const modal = document.createElement('div');
            modal.className = 'modal-overlay';
            modal.style.cssText = `
                position: fixed !important;
                top: 0 !important;
                left: 0 !important;
                width: 100% !important;
                height: 100% !important;
                background: rgba(0,0,0,0.9) !important;
                z-index: 999999 !important;
                display: flex !important;
                align-items: center !important;
                justify-content: center !important;
                visibility: visible !important;
                opacity: 1 !important;
            `;
            
            modal.innerHTML = `
                <div style="
                    background: linear-gradient(135deg, rgba(0,0,0,0.95), rgba(20,20,40,0.98)) !important;
                    border: 3px solid rgba(144, 238, 144, 0.6) !important;
                    border-radius: 20px !important;
                    padding: 40px !important;
                    max-width: 600px !important;
                    width: 90% !important;
                    text-align: center !important;
                    box-shadow: 0 0 50px rgba(144, 238, 144, 0.3) !important;
                    position: relative !important;
                    z-index: 1000000 !important;
                ">
                    <h2 style="color: #90ee90 !important; margin-bottom: 20px !important; font-size: 24px !important;">🧠 Modal Grok de Teste</h2>
                    <p style="color: #b9f9b9 !important; margin-bottom: 30px !important; font-size: 16px !important;">Se você está vendo isso, o modal funciona perfeitamente!</p>
                    <button onclick="this.closest('.modal-overlay').remove()" style="
                        background: linear-gradient(135deg, rgba(144, 238, 144, 0.3), rgba(144, 238, 144, 0.5)) !important;
                        border: 2px solid rgba(144, 238, 144, 0.7) !important;
                        color: #90ee90 !important;
                        padding: 15px 30px !important;
                        border-radius: 25px !important;
                        cursor: pointer !important;
                        font-size: 16px !important;
                        font-weight: bold !important;
                        transition: all 0.3s ease !important;
                    " onmouseover="this.style.background='linear-gradient(135deg, rgba(144, 238, 144, 0.5), rgba(144, 238, 144, 0.7))'" onmouseout="this.style.background='linear-gradient(135deg, rgba(144, 238, 144, 0.3), rgba(144, 238, 144, 0.5))'">Fechar</button>
                </div>
            `;
            
            document.body.appendChild(modal);
            console.log('✅ Modal adicionado ao DOM:', modal);
        }
        
        // Função para criar modal de guia
        function showGuideModal(guideType, btn) {
            console.log('🧠 showGuideModal chamada:', guideType, btn);
            
            // Remover modal anterior se existir
            const existingModal = document.querySelector('.modal-overlay');
            if (existingModal) {
                existingModal.remove();
            }
            
            // Conteúdo baseado no tipo de guia
            let content = '';
            let title = '';
            
            if (guideType.includes('navegação') || guideType.includes('navegacao')) {
                title = '🧭 Guia de Navegação Segura';
                content = `
                    <div style="text-align: left; color: #b9f9b9; line-height: 1.6;">
                        <h3 style="color: #90ee90; margin-bottom: 15px;">🌐 Navegação Segura</h3>
                        <ul style="margin-bottom: 20px;">
                            <li>✅ Use sempre HTTPS (cadeado verde)</li>
                            <li>✅ Verifique a URL antes de digitar dados</li>
                            <li>✅ Evite links suspeitos em emails</li>
                            <li>✅ Use navegadores atualizados</li>
                            <li>✅ Ative autenticação de dois fatores</li>
                        </ul>
                        <h3 style="color: #90ee90; margin-bottom: 15px;">🔒 Dicas Extras</h3>
                        <ul>
                            <li>🚫 Nunca compartilhe senhas</li>
                            <li>🔄 Use senhas únicas para cada site</li>
                            <li>📱 Configure alertas de segurança</li>
                        </ul>
                    </div>
                `;
            } else if (guideType.includes('mobile') || guideType.includes('celular')) {
                title = '📱 Guia de Segurança Mobile';
                content = `
                    <div style="text-align: left; color: #b9f9b9; line-height: 1.6;">
                        <h3 style="color: #90ee90; margin-bottom: 15px;">📱 Proteção Mobile</h3>
                        <ul style="margin-bottom: 20px;">
                            <li>✅ Ative bloqueio de tela</li>
                            <li>✅ Use biometria quando possível</li>
                            <li>✅ Mantenha apps atualizados</li>
                            <li>✅ Evite redes WiFi públicas</li>
                            <li>✅ Use VPN em redes desconhecidas</li>
                        </ul>
                        <h3 style="color: #90ee90; margin-bottom: 15px;">🛡️ Apps Seguros</h3>
                        <ul>
                            <li>📥 Baixe apenas de lojas oficiais</li>
                            <li>🔍 Verifique permissões dos apps</li>
                            <li>🗑️ Remova apps não utilizados</li>
                        </ul>
                    </div>
                `;
            } else if (guideType.includes('email') || guideType.includes('e-mail')) {
                title = '📧 Guia de Segurança de Email';
                content = `
                    <div style="text-align: left; color: #b9f9b9; line-height: 1.6;">
                        <h3 style="color: #90ee90; margin-bottom: 15px;">📧 Email Seguro</h3>
                        <ul style="margin-bottom: 20px;">
                            <li>✅ Verifique o remetente</li>
                            <li>✅ Não clique em links suspeitos</li>
                            <li>✅ Use filtros anti-spam</li>
                            <li>✅ Criptografe emails sensíveis</li>
                            <li>✅ Faça backup regular</li>
                        </ul>
                        <h3 style="color: #90ee90; margin-bottom: 15px;">🚨 Sinais de Phishing</h3>
                        <ul>
                            <li>⚠️ Urgência excessiva</li>
                            <li>⚠️ Erros de português</li>
                            <li>⚠️ Links estranhos</li>
                        </ul>
                    </div>
                `;
            } else if (guideType.includes('cripto') || guideType.includes('crypto')) {
                title = '₿ Guia de Segurança Cripto';
                content = `
                    <div style="text-align: left; color: #b9f9b9; line-height: 1.6;">
                        <h3 style="color: #90ee90; margin-bottom: 15px;">₿ Criptomoedas Seguras</h3>
                        <ul style="margin-bottom: 20px;">
                            <li>✅ Use carteiras hardware</li>
                            <li>✅ Nunca compartilhe chaves privadas</li>
                            <li>✅ Verifique endereços antes de enviar</li>
                            <li>✅ Use exchanges confiáveis</li>
                            <li>✅ Ative 2FA em todas as contas</li>
                        </ul>
                        <h3 style="color: #90ee90; margin-bottom: 15px;">🔐 Armazenamento</h3>
                        <ul>
                            <li>💾 Faça backup das seed phrases</li>
                            <li>🏠 Mantenha offline quando possível</li>
                            <li>🔄 Diversifique investimentos</li>
                        </ul>
                    </div>
                `;
            } else {
                title = '📚 Guia de Segurança Digital';
                content = `
                    <div style="text-align: left; color: #b9f9b9; line-height: 1.6;">
                        <h3 style="color: #90ee90; margin-bottom: 15px;">🛡️ Segurança Básica</h3>
                        <ul style="margin-bottom: 20px;">
                            <li>✅ Use senhas fortes e únicas</li>
                            <li>✅ Ative autenticação de dois fatores</li>
                            <li>✅ Mantenha software atualizado</li>
                            <li>✅ Use antivírus confiável</li>
                            <li>✅ Faça backup regular dos dados</li>
                        </ul>
                        <h3 style="color: #90ee90; margin-bottom: 15px;">🔍 Monitoramento</h3>
                        <ul>
                            <li>👁️ Monitore contas regularmente</li>
                            <li>📊 Use ferramentas de segurança</li>
                            <li>🚨 Configure alertas de segurança</li>
                        </ul>
                    </div>
                `;
            }
            
            const modal = document.createElement('div');
            modal.className = 'modal-overlay';
            modal.style.cssText = `
                position: fixed !important;
                top: 0 !important;
                left: 0 !important;
                width: 100% !important;
                height: 100% !important;
                background: rgba(0,0,0,0.95) !important;
                z-index: 999999 !important;
                display: flex !important;
                align-items: center !important;
                justify-content: center !important;
                visibility: visible !important;
                opacity: 1 !important;
            `;
            
            modal.innerHTML = `
                <div style="
                    background: linear-gradient(135deg, rgba(0,0,0,0.95), rgba(20,20,40,0.98)) !important;
                    border: 3px solid rgba(144, 238, 144, 0.6) !important;
                    border-radius: 20px !important;
                    padding: 40px !important;
                    max-width: 700px !important;
                    width: 90% !important;
                    max-height: 80vh !important;
                    overflow-y: auto !important;
                    box-shadow: 0 0 50px rgba(144, 238, 144, 0.3) !important;
                    position: relative !important;
                    z-index: 1000000 !important;
                ">
                    <h2 style="color: #90ee90 !important; margin-bottom: 25px !important; font-size: 24px !important; text-align: center !important;">${title}</h2>
                    ${content}
                    <div style="text-align: center; margin-top: 30px;">
                        <button onclick="this.closest('.modal-overlay').remove()" style="
                            background: linear-gradient(135deg, rgba(144, 238, 144, 0.3), rgba(144, 238, 144, 0.5)) !important;
                            border: 2px solid rgba(144, 238, 144, 0.7) !important;
                            color: #90ee90 !important;
                            padding: 15px 30px !important;
                            border-radius: 25px !important;
                            cursor: pointer !important;
                            font-size: 16px !important;
                            font-weight: bold !important;
                            margin-right: 15px !important;
                        ">Fechar</button>
                        <button onclick="
                            const email = 'lucasdeandrade0077@gmail.com';
                            const subject = 'Solicitação de Guia Completo - ${title}';
                            const body = 'Olá! Gostaria de receber o guia completo sobre: ${title}\\n\\nDetalhes:\\n- Tipo: ${guideType}\\n- Página: ${window.location.href}\\n\\nPor favor, envie o guia completo com mais detalhes e exemplos práticos.\\n\\nObrigado!';
                            window.open('mailto:' + email + '?subject=' + encodeURIComponent(subject) + '&body=' + encodeURIComponent(body));
                        " style="
                            background: linear-gradient(135deg, rgba(255, 165, 0, 0.3), rgba(255, 165, 0, 0.5)) !important;
                            border: 2px solid rgba(255, 165, 0, 0.7) !important;
                            color: #ffa500 !important;
                            padding: 15px 30px !important;
                            border-radius: 25px !important;
                            cursor: pointer !important;
                            font-size: 16px !important;
                            font-weight: bold !important;
                        ">📧 Solicitar Guia Completo</button>
                    </div>
                </div>
            `;
            
            document.body.appendChild(modal);
            console.log('✅ Modal de guia criado:', modal);
        }
        
        // Configurar botões "Ler Guia" quando a página carregar
        document.addEventListener('DOMContentLoaded', function() {
            console.log('🔍 Configurando botões "Ler Guia"...');
            
            // Aguardar um pouco para garantir que todos os elementos estão carregados
            setTimeout(function() {
                const guideButtons = document.querySelectorAll('button, a');
                console.log('🔍 Botões encontrados:', guideButtons.length);
                
                guideButtons.forEach(function(btn) {
                    const text = btn.textContent.toLowerCase();
                    if (text.includes('ler guia') || text.includes('guia')) {
                        console.log('🎯 Botão de guia encontrado:', btn.textContent);
                        
                        btn.addEventListener('click', function(e) {
                            e.preventDefault();
                            e.stopPropagation();
                            
                            console.log('🎯 Botão de guia clicado:', btn.textContent);
                            showGuideModal(btn.textContent, btn);
                        });
                    }
                });
            }, 1000);
        });
        
        // Botão de teste removido - modais implementados
    </script>
    <script src="<?php echo asset('js/modals.js'); ?>"></script>
    <script src="<?php echo asset('script.js'); ?>" defer></script>
</body>
</html>
