<?php
require_once 'domain-config.php';
header('Content-Type: text/html; charset=utf-8');
date_default_timezone_set('America/Sao_Paulo');
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Segurança | CyberNews</title>
    <meta name="description" content="Guias completos de segurança digital, boas práticas, ferramentas de proteção e estratégias de defesa cibernética.">
    <meta name="robots" content="index,follow">
    <link rel="canonical" href="<?php echo url('seguranca'); ?>">

    <!-- Open Graph -->
    <meta property="og:title" content="Segurança Digital - CyberNews">
    <meta property="og:description" content="Aprenda a proteger seus sistemas e dados com nossas estratégias de segurança.">
    <meta property="og:type" content="website">
    <meta property="og:url" content="/seguranca">
    <meta property="og:site_name" content="CyberNews">

    <link rel="stylesheet" href="<?php echo asset('styles.css'); ?>">
    <link rel="stylesheet" href="<?php echo asset('css/news-psychedelic.css'); ?>">
    <link rel="stylesheet" href="<?php echo asset('css/sections.css'); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
    
    <!-- Google Analytics -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-JBDJ3PPN93"></script>
    <script>
      window.dataLayer = window.dataLayer || [];
      function gtag(){dataLayer.push(arguments);}
      gtag('js', new Date());
      gtag('config', 'G-JBDJ3PPN93');
    </script>
</head>
<body class="psychedelic-mode">
    <!-- Preloader -->
    <div id="preloader">
        <div class="circuit-lines"></div>
        <div class="binary-text"></div>
        <div class="scan-line"></div>
        <div class="preloader-content">
            <div class="holo-container">
                <div class="rotating-ring"></div>
                <div class="rotating-ring"></div>
                <div class="rotating-ring"></div>
                <div class="tech-circle"></div>
                <div class="hex-spinner">
                    <div class="hex"></div>
                    <div class="hex"></div>
                    <div class="hex"></div>
                    <div class="hex"></div>
                    <div class="hex"></div>
                    <div class="hex"></div>
                </div>
                <div class="loading-bubbles">
                    <div class="bubble psychedelic"></div>
                    <div class="bubble psychedelic"></div>
                    <div class="bubble psychedelic"></div>
                    <div class="bubble psychedelic"></div>
                    <div class="bubble psychedelic"></div>
                    <div class="bubble psychedelic"></div>
                </div>
                <div class="neon-text">
                    <span class="glitch-text" data-text="SEGURANÇA">SEGURANÇA</span>
                    <div class="loading-dots">
                        <span></span><span></span><span></span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Botão Voltar ao Topo -->
    <div class="back-to-top">
        <i class="fas fa-arrow-up"></i>
    </div>

    <!-- Menu Lateral -->
    <div class="psychedelic-menu-container">
        <div class="menu-toggle">
            <div class="hamburger">
                <span></span>
                <span></span>
                <span></span>
            </div>
        </div>
        
        <nav class="side-menu">
            <div class="menu-background">
                <div class="liquid-shape"></div>
                <div class="fractal-pattern"></div>
                <div class="glow-particles"></div>
            </div>
            
            <div class="menu-content">
                <div class="menu-header">
                    <div class="menu-logo">
                        <h2>CyberNews</h2>
                    </div>
                </div>
                
                <ul class="menu-items">
                    <li class="menu-item">
                        <a href="<?php echo url(''); ?>" class="menu-link">
                            <i class="fas fa-home"></i>
                            <span>Início</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                    <li class="menu-item">
                        <a href="<?php echo url('noticias'); ?>" class="menu-link">
                            <i class="fas fa-newspaper"></i>
                            <span>Notícias</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                    <li class="menu-item active">
                        <a href="<?php echo url('seguranca'); ?>" class="menu-link">
                            <i class="fas fa-lock"></i>
                            <span>Segurança</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                    <li class="menu-item">
                        <a href="<?php echo url('vulnerabilidades'); ?>" class="menu-link">
                            <i class="fas fa-bug"></i>
                            <span>Vulnerabilidades</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                    <li class="menu-item">
                        <a href="<?php echo url('malware'); ?>" class="menu-link">
                            <i class="fas fa-virus"></i>
                            <span>Malware</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                    <li class="menu-item">
                        <a href="<?php echo url('privacidade'); ?>" class="menu-link">
                            <i class="fas fa-user-secret"></i>
                            <span>Privacidade</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                    <li class="menu-item">
                        <a href="<?php echo url('loja'); ?>" class="menu-link" aria-label="Loja">
                            <i class="fas fa-shopping-cart" aria-hidden="true"></i>
                            <span>Loja</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                    <li class="menu-item">
                        <a href="https://lucas.br.vc/" class="menu-link" target="_blank" aria-label="Contato">
                            <i class="fas fa-envelope" aria-hidden="true"></i>
                            <span>Contato</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                </ul>
                
                <div class="menu-footer">
                    <div class="social-icons">
                        <a href="#" class="social-icon"><i class="fab fa-twitter"></i></a>
                        <a href="#" class="social-icon"><i class="fab fa-github"></i></a>
                        <a href="#" class="social-icon"><i class="fab fa-linkedin"></i></a>
                    </div>
                    <div class="admin-menu-access">
                        <a href="<?php echo url('admin/'); ?>" class="admin-menu-btn" title="Painel Admin">
                            <i class="fas fa-cogs"></i>
                        </a>
                    </div>
                </div>
            </div>
        </nav>
    </div>

    <header>
        <div class="container" role="banner">
            <div class="logo" aria-label="CyberNews Logo">
                <h1 style="margin:0;">CyberNews</h1>
            </div>
            <nav aria-label="Navegação principal">
                <a href="<?php echo url(''); ?>" class="admin-btn" style="text-decoration:none;">
                    <i class="fas fa-home" aria-hidden="true"></i> Início
                </a>
            </nav>
        </div>
    </header>

    <main class="main-content" role="main">
        <div id="main-content">
            <div class="container">
                <section class="store-hero" aria-labelledby="security-title">
                    <h1 id="security-title">🔒 Segurança Digital</h1>
                    <p>Estratégias, ferramentas e boas práticas para proteger seus sistemas e dados contra ameaças cibernéticas.</p>
                </section>

                <!-- Dashboard de Segurança -->
                <section class="security-dashboard" aria-label="Dashboard de Segurança">
                    <div class="section-header">
                        <h2>📊 Status de Segurança Global</h2>
                        <p>Panorama atual das ameaças e incidentes de segurança</p>
                    </div>
                    
                    <div class="security-stats">
                        <div class="stat-card threat-level">
                            <div class="stat-icon">
                                <i class="fas fa-exclamation-triangle"></i>
                            </div>
                            <div class="stat-content">
                                <h3>ELEVADO</h3>
                                <p>Nível de Ameaça<br><small>Baseado em inteligência global</small></p>
                            </div>
                            <div class="threat-indicator high"></div>
                        </div>
                        <div class="stat-card incidents">
                            <div class="stat-icon">
                                <i class="fas fa-fire"></i>
                            </div>
                            <div class="stat-content">
                                <h3>2,847</h3>
                                <p>Incidentes Reportados<br><small>Últimas 24 horas</small></p>
                            </div>
                        </div>
                        <div class="stat-card ransomware">
                            <div class="stat-icon">
                                <i class="fas fa-lock"></i>
                            </div>
                            <div class="stat-content">
                                <h3>156</h3>
                                <p>Ataques Ransomware<br><small>Esta semana</small></p>
                            </div>
                        </div>
                        <div class="stat-card data-breaches">
                            <div class="stat-icon">
                                <i class="fas fa-database"></i>
                            </div>
                            <div class="stat-content">
                                <h3>23.4M</h3>
                                <p>Registros Vazados<br><small>Este mês</small></p>
                            </div>
                        </div>
                    </div>
                </section>

                <!-- Frameworks de Segurança -->
                <section class="security-frameworks" aria-label="Frameworks de Segurança">
                    <div class="section-header">
                        <h2>🏗️ Frameworks de Segurança</h2>
                        <p>Principais frameworks e metodologias para implementar segurança efetiva</p>
                    </div>
                    
                    <div class="frameworks-grid">
                        <article class="framework-card">
                            <div class="framework-header">
                                <div class="framework-icon">
                                    <i class="fas fa-shield-alt"></i>
                                </div>
                                <h3>NIST Cybersecurity Framework</h3>
                            </div>
                            <p>Framework abrangente para gerenciar e reduzir riscos de cibersegurança</p>
                            <div class="framework-functions">
                                <div class="function-item">
                                    <strong>IDENTIFY</strong>
                                    <span>Desenvolver compreensão organizacional</span>
                                </div>
                                <div class="function-item">
                                    <strong>PROTECT</strong>
                                    <span>Desenvolver salvaguardas apropriadas</span>
                                </div>
                                <div class="function-item">
                                    <strong>DETECT</strong>
                                    <span>Desenvolver atividades de detecção</span>
                                </div>
                                <div class="function-item">
                                    <strong>RESPOND</strong>
                                    <span>Desenvolver atividades de resposta</span>
                                </div>
                                <div class="function-item">
                                    <strong>RECOVER</strong>
                                    <span>Desenvolver planos de recuperação</span>
                                </div>
                            </div>
                            <a href="#" class="framework-btn">📚 Estudar NIST</a>
                        </article>

                        <article class="framework-card">
                            <div class="framework-header">
                                <div class="framework-icon">
                                    <i class="fas fa-globe"></i>
                                </div>
                                <h3>ISO/IEC 27001</h3>
                            </div>
                            <p>Padrão internacional para sistemas de gestão de segurança da informação</p>
                            <div class="framework-functions">
                                <div class="function-item">
                                    <strong>PLAN</strong>
                                    <span>Estabelecer SGSI e políticas</span>
                                </div>
                                <div class="function-item">
                                    <strong>DO</strong>
                                    <span>Implementar controles e processos</span>
                                </div>
                                <div class="function-item">
                                    <strong>CHECK</strong>
                                    <span>Monitorar e revisar o SGSI</span>
                                </div>
                                <div class="function-item">
                                    <strong>ACT</strong>
                                    <span>Manter e melhorar o SGSI</span>
                                </div>
                            </div>
                            <a href="#" class="framework-btn">🏆 Certificação ISO</a>
                        </article>

                        <article class="framework-card">
                            <div class="framework-header">
                                <div class="framework-icon">
                                    <i class="fas fa-chess"></i>
                                </div>
                                <h3>MITRE ATT&CK</h3>
                            </div>
                            <p>Framework de táticas, técnicas e procedimentos de adversários</p>
                            <div class="framework-functions">
                                <div class="function-item">
                                    <strong>TACTICS</strong>
                                    <span>Objetivos técnicos dos adversários</span>
                                </div>
                                <div class="function-item">
                                    <strong>TECHNIQUES</strong>
                                    <span>Como os adversários alcançam objetivos</span>
                                </div>
                                <div class="function-item">
                                    <strong>PROCEDURES</strong>
                                    <span>Implementações específicas de técnicas</span>
                                </div>
                            </div>
                            <a href="#" class="framework-btn">🎯 Explorar ATT&CK</a>
                        </article>
                    </div>
                </section>

                <!-- Ferramentas de Segurança -->
                <section class="security-tools" aria-label="Ferramentas de Segurança">
                    <div class="section-header">
                        <h2>🛡️ Arsenal de Segurança</h2>
                        <p>Ferramentas essenciais para implementar e manter segurança robusta</p>
                    </div>
                    
                    <div class="tools-categories">
                        <div class="tool-category">
                            <h3>🔍 SIEM & Monitoramento</h3>
                            <div class="tool-list">
                                <div class="tool-item enterprise">
                                    <div class="tool-header">
                                        <strong>Splunk Enterprise Security</strong>
                                        <span class="tool-type enterprise">ENTERPRISE</span>
                                    </div>
                                    <p>Plataforma SIEM líder para análise de segurança em tempo real</p>
                                    <div class="tool-features">
                                        <span>✅ Machine Learning</span>
                                        <span>✅ Threat Intelligence</span>
                                        <span>✅ SOAR Integration</span>
                                        <span>✅ Advanced Analytics</span>
                                    </div>
                                    <a href="#" class="tool-link">Avaliar</a>
                                </div>
                                
                                <div class="tool-item opensource">
                                    <div class="tool-header">
                                        <strong>Elastic Security (ELK)</strong>
                                        <span class="tool-type opensource">OPEN SOURCE</span>
                                    </div>
                                    <p>Stack completo para busca, análise e visualização de dados de segurança</p>
                                    <div class="tool-features">
                                        <span>✅ Elasticsearch</span>
                                        <span>✅ Logstash</span>
                                        <span>✅ Kibana</span>
                                        <span>✅ Beats</span>
                                    </div>
                                    <a href="#" class="tool-link">Download</a>
                                </div>

                                <div class="tool-item cloud">
                                    <div class="tool-header">
                                        <strong>Azure Sentinel</strong>
                                        <span class="tool-type cloud">CLOUD</span>
                                    </div>
                                    <p>SIEM nativo da nuvem com IA integrada</p>
                                    <div class="tool-features">
                                        <span>✅ Cloud-native</span>
                                        <span>✅ AI/ML Built-in</span>
                                        <span>✅ Threat Hunting</span>
                                        <span>✅ Automated Response</span>
                                    </div>
                                    <a href="#" class="tool-link">Experimentar</a>
                                </div>
                            </div>
                        </div>

                        <div class="tool-category">
                            <h3>🛡️ Endpoint Protection</h3>
                            <div class="tool-list">
                                <div class="tool-item enterprise">
                                    <div class="tool-header">
                                        <strong>CrowdStrike Falcon</strong>
                                        <span class="tool-type enterprise">ENTERPRISE</span>
                                    </div>
                                    <p>Proteção de endpoint baseada em cloud com IA</p>
                                    <div class="tool-features">
                                        <span>✅ Next-Gen AV</span>
                                        <span>✅ EDR/XDR</span>
                                        <span>✅ Threat Intelligence</span>
                                        <span>✅ Managed Hunting</span>
                                    </div>
                                    <a href="#" class="tool-link">Demo</a>
                                </div>

                                <div class="tool-item opensource">
                                    <div class="tool-header">
                                        <strong>Wazuh</strong>
                                        <span class="tool-type opensource">OPEN SOURCE</span>
                                    </div>
                                    <p>Plataforma unificada XDR e SIEM open source</p>
                                    <div class="tool-features">
                                        <span>✅ Host-based IDS</span>
                                        <span>✅ Log Analysis</span>
                                        <span>✅ File Integrity</span>
                                        <span>✅ Vulnerability Detection</span>
                                    </div>
                                    <a href="#" class="tool-link">Download</a>
                                </div>

                                <div class="tool-item enterprise">
                                    <div class="tool-header">
                                        <strong>Microsoft Defender</strong>
                                        <span class="tool-type enterprise">ENTERPRISE</span>
                                    </div>
                                    <p>Suite completa de proteção Microsoft 365</p>
                                    <div class="tool-features">
                                        <span>✅ ATP</span>
                                        <span>✅ Cloud App Security</span>
                                        <span>✅ Identity Protection</span>
                                        <span>✅ Information Protection</span>
                                    </div>
                                    <a href="#" class="tool-link">Configurar</a>
                                </div>
                            </div>
                        </div>

                        <div class="tool-category">
                            <h3>🌐 Network Security</h3>
                            <div class="tool-list">
                                <div class="tool-item enterprise">
                                    <div class="tool-header">
                                        <strong>Palo Alto Networks</strong>
                                        <span class="tool-type enterprise">ENTERPRISE</span>
                                    </div>
                                    <p>Next-Generation Firewall com prevenção avançada</p>
                                    <div class="tool-features">
                                        <span>✅ NGFW</span>
                                        <span>✅ Threat Prevention</span>
                                        <span>✅ URL Filtering</span>
                                        <span>✅ Wildfire Analysis</span>
                                    </div>
                                    <a href="#" class="tool-link">Avaliar</a>
                                </div>

                                <div class="tool-item opensource">
                                    <div class="tool-header">
                                        <strong>pfSense</strong>
                                        <span class="tool-type opensource">OPEN SOURCE</span>
                                    </div>
                                    <p>Firewall e roteador baseado em FreeBSD</p>
                                    <div class="tool-features">
                                        <span>✅ Stateful Firewall</span>
                                        <span>✅ VPN Support</span>
                                        <span>✅ Traffic Shaping</span>
                                        <span>✅ Package System</span>
                                    </div>
                                    <a href="#" class="tool-link">Download</a>
                                </div>

                                <div class="tool-item opensource">
                                    <div class="tool-header">
                                        <strong>Suricata</strong>
                                        <span class="tool-type opensource">OPEN SOURCE</span>
                                    </div>
                                    <p>Engine IDS/IPS de alta performance</p>
                                    <div class="tool-features">
                                        <span>✅ Multi-threading</span>
                                        <span>✅ Protocol Analysis</span>
                                        <span>✅ File Extraction</span>
                                        <span>✅ Lua Scripting</span>
                                    </div>
                                    <a href="#" class="tool-link">Download</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>

                <!-- Guias de Implementação -->
                <section class="implementation-guides" aria-label="Guias de Implementação">
                    <div class="section-header">
                        <h2>📋 Guias de Implementação</h2>
                        <p>Passo a passo para implementar controles de segurança efetivos</p>
                    </div>
                    
                    <div class="guides-grid">
                        <article class="guide-card">
                            <div class="guide-icon">
                                <i class="fas fa-network-wired"></i>
                            </div>
                            <h3>Segmentação de Rede</h3>
                            <p>Como implementar microsegmentação e Zero Trust</p>
                            <div class="guide-steps">
                                <div class="step">1. Mapeamento de ativos</div>
                                <div class="step">2. Classificação de dados</div>
                                <div class="step">3. Design de segmentos</div>
                                <div class="step">4. Implementação de controles</div>
                                <div class="step">5. Monitoramento contínuo</div>
                            </div>
                            <a href="#" class="guide-btn">📖 Ler Guia Completo</a>
                        </article>

                        <article class="guide-card">
                            <div class="guide-icon">
                                <i class="fas fa-user-shield"></i>
                            </div>
                            <h3>Identity & Access Management</h3>
                            <p>Implementação de IAM robusto com MFA e PAM</p>
                            <div class="guide-steps">
                                <div class="step">1. Inventário de identidades</div>
                                <div class="step">2. Políticas de acesso</div>
                                <div class="step">3. Multi-Factor Authentication</div>
                                <div class="step">4. Privileged Access Management</div>
                                <div class="step">5. Revisão de acessos</div>
                            </div>
                            <a href="#" class="guide-btn">🔐 Implementar IAM</a>
                        </article>

                        <article class="guide-card">
                            <div class="guide-icon">
                                <i class="fas fa-database"></i>
                            </div>
                            <h3>Proteção de Dados</h3>
                            <p>Estratégias de DLP e criptografia de dados</p>
                            <div class="guide-steps">
                                <div class="step">1. Descoberta de dados</div>
                                <div class="step">2. Classificação e rotulagem</div>
                                <div class="step">3. Políticas de DLP</div>
                                <div class="step">4. Criptografia em repouso/trânsito</div>
                                <div class="step">5. Monitoramento de vazamentos</div>
                            </div>
                            <a href="#" class="guide-btn">🛡️ Proteger Dados</a>
                        </article>

                        <article class="guide-card">
                            <div class="guide-icon">
                                <i class="fas fa-bug"></i>
                            </div>
                            <h3>Resposta a Incidentes</h3>
                            <p>Criação de playbooks e CSIRT efetivo</p>
                            <div class="guide-steps">
                                <div class="step">1. Preparação e planejamento</div>
                                <div class="step">2. Detecção e análise</div>
                                <div class="step">3. Contenção e erradicação</div>
                                <div class="step">4. Recuperação</div>
                                <div class="step">5. Lições aprendidas</div>
                            </div>
                            <a href="#" class="guide-btn">🚨 Criar CSIRT</a>
                        </article>
                    </div>
                </section>

                <!-- Compliance e Regulamentações -->
                <section class="compliance-section" aria-label="Compliance e Regulamentações">
                    <div class="section-header">
                        <h2>📜 Compliance e Regulamentações</h2>
                        <p>Principais regulamentações de segurança e privacidade</p>
                    </div>
                    
                    <div class="compliance-grid">
                        <div class="compliance-card">
                            <div class="compliance-flag">🇧🇷</div>
                            <h3>LGPD</h3>
                            <p>Lei Geral de Proteção de Dados Pessoais</p>
                            <ul>
                                <li>• Proteção de dados pessoais</li>
                                <li>• Consentimento e transparência</li>
                                <li>• Direitos dos titulares</li>
                                <li>• Multas até R$ 50 milhões</li>
                            </ul>
                            <a href="#" class="compliance-btn">📋 Checklist LGPD</a>
                        </div>

                        <div class="compliance-card">
                            <div class="compliance-flag">🇪🇺</div>
                            <h3>GDPR</h3>
                            <p>General Data Protection Regulation</p>
                            <ul>
                                <li>• Proteção de dados na UE</li>
                                <li>• Privacy by Design</li>
                                <li>• DPO obrigatório</li>
                                <li>• Multas até 4% do faturamento</li>
                            </ul>
                            <a href="#" class="compliance-btn">🇪🇺 Guia GDPR</a>
                        </div>

                        <div class="compliance-card">
                            <div class="compliance-flag">🏦</div>
                            <h3>PCI DSS</h3>
                            <p>Payment Card Industry Data Security Standard</p>
                            <ul>
                                <li>• Proteção de dados de cartão</li>
                                <li>• 12 requisitos principais</li>
                                <li>• Testes de penetração</li>
                                <li>• Certificação anual</li>
                            </ul>
                            <a href="#" class="compliance-btn">💳 Implementar PCI</a>
                        </div>

                        <div class="compliance-card">
                            <div class="compliance-flag">🏥</div>
                            <h3>HIPAA</h3>
                            <p>Health Insurance Portability and Accountability Act</p>
                            <ul>
                                <li>• Proteção de dados de saúde</li>
                                <li>• Salvaguardas administrativas</li>
                                <li>• Controles físicos e técnicos</li>
                                <li>• Breach notification</li>
                            </ul>
                            <a href="#" class="compliance-btn">🏥 Compliance HIPAA</a>
                        </div>
                    </div>
                </section>

                <!-- Treinamento e Conscientização -->
                <section class="training-section" aria-label="Treinamento e Conscientização">
                    <div class="section-header">
                        <h2>🎓 Treinamento e Conscientização</h2>
                        <p>Programas de educação em segurança para equipes</p>
                    </div>
                    
                    <div class="training-grid">
                        <div class="training-card">
                            <div class="training-icon">
                                <i class="fas fa-users"></i>
                            </div>
                            <h3>Security Awareness</h3>
                            <p>Programa de conscientização para funcionários</p>
                            <ul>
                                <li>• Phishing simulation</li>
                                <li>• Treinamentos interativos</li>
                                <li>• Métricas de engajamento</li>
                                <li>• Certificados de conclusão</li>
                            </ul>
                            <a href="#" class="training-btn">👥 Iniciar Programa</a>
                        </div>

                        <div class="training-card">
                            <div class="training-icon">
                                <i class="fas fa-code"></i>
                            </div>
                            <h3>Secure Coding</h3>
                            <p>Desenvolvimento seguro para programadores</p>
                            <ul>
                                <li>• OWASP Top 10</li>
                                <li>• Code review security</li>
                                <li>• Secure SDLC</li>
                                <li>• Hands-on labs</li>
                            </ul>
                            <a href="#" class="training-btn">💻 Treinar Devs</a>
                        </div>

                        <div class="training-card">
                            <div class="training-icon">
                                <i class="fas fa-shield-alt"></i>
                            </div>
                            <h3>Incident Response</h3>
                            <p>Treinamento de resposta a incidentes</p>
                            <ul>
                                <li>• Simulações de incidentes</li>
                                <li>• Playbook training</li>
                                <li>• Forensics basics</li>
                                <li>• Communication protocols</li>
                            </ul>
                            <a href="#" class="training-btn">🚨 Treinar CSIRT</a>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </main>

    <footer>
        <div class="container">
            <div class="footer-content">
                <div class="footer-logo">
                    <h2>CyberNews</h2>
                </div>
                <p>Construindo defesas digitais robustas.</p>
            </div>
            <div class="copyright">
                <p>&copy; <?= date('Y') ?> CyberNews - Todos os direitos reservados.</p>
            </div>
        </div>
    </footer>
    
    <script src="<?php echo asset('js/performance.js'); ?>" defer></script>
    <script>
        // Função para criar modal de guia
        function showGuideModal(guideType, btn) {
            console.log('🧠 showGuideModal chamada:', guideType, btn);
            
            // Remover modal anterior se existir
            const existingModal = document.querySelector('.modal-overlay');
            if (existingModal) {
                existingModal.remove();
            }
            
            // Conteúdo baseado no tipo de guia
            let content = '';
            let title = '';
            
            if (guideType.includes('segurança') || guideType.includes('seguranca')) {
                title = '🛡️ Guia de Segurança Corporativa';
                content = `
                    <div style="text-align: left; color: #b9f9b9; line-height: 1.6;">
                        <h3 style="color: #90ee90; margin-bottom: 15px;">🏢 Segurança Corporativa</h3>
                        <ul style="margin-bottom: 20px;">
                            <li>✅ Implemente políticas de segurança</li>
                            <li>✅ Treine funcionários regularmente</li>
                            <li>✅ Use controle de acesso baseado em função</li>
                            <li>✅ Monitore atividades suspeitas</li>
                            <li>✅ Faça auditorias de segurança</li>
                        </ul>
                        <h3 style="color: #90ee90; margin-bottom: 15px;">🔐 Controles de Acesso</h3>
                        <ul>
                            <li>🔑 Use autenticação multifator</li>
                            <li>📊 Implemente princípio do menor privilégio</li>
                            <li>🔄 Revise permissões regularmente</li>
                        </ul>
                    </div>
                `;
            } else if (guideType.includes('compliance') || guideType.includes('conformidade')) {
                title = '📋 Guia de Compliance e Conformidade';
                content = `
                    <div style="text-align: left; color: #b9f9b9; line-height: 1.6;">
                        <h3 style="color: #90ee90; margin-bottom: 15px;">📋 Compliance</h3>
                        <ul style="margin-bottom: 20px;">
                            <li>✅ Conheça regulamentações aplicáveis</li>
                            <li>✅ Implemente controles necessários</li>
                            <li>✅ Documente processos e políticas</li>
                            <li>✅ Faça auditorias regulares</li>
                            <li>✅ Mantenha registros atualizados</li>
                        </ul>
                        <h3 style="color: #90ee90; margin-bottom: 15px;">📊 Monitoramento</h3>
                        <ul>
                            <li>📈 Monitore métricas de compliance</li>
                            <li>🚨 Configure alertas de violação</li>
                            <li>📝 Mantenha evidências de conformidade</li>
                        </ul>
                    </div>
                `;
            } else {
                title = '🛡️ Guia de Segurança Avançada';
                content = `
                    <div style="text-align: left; color: #b9f9b9; line-height: 1.6;">
                        <h3 style="color: #90ee90; margin-bottom: 15px;">🔒 Segurança Avançada</h3>
                        <ul style="margin-bottom: 20px;">
                            <li>✅ Implemente arquitetura de defesa em profundidade</li>
                            <li>✅ Use criptografia end-to-end</li>
                            <li>✅ Monitore comportamento anômalo</li>
                            <li>✅ Implemente resposta a incidentes</li>
                            <li>✅ Faça testes de penetração regulares</li>
                        </ul>
                        <h3 style="color: #90ee90; margin-bottom: 15px;">🚨 Resposta a Incidentes</h3>
                        <ul>
                            <li>📋 Tenha plano de resposta definido</li>
                            <li>⚡ Aja rapidamente em caso de incidente</li>
                            <li>📞 Comunique stakeholders relevantes</li>
                        </ul>
                    </div>
                `;
            }
            
            const modal = document.createElement('div');
            modal.className = 'modal-overlay';
            modal.style.cssText = `
                position: fixed !important;
                top: 0 !important;
                left: 0 !important;
                width: 100% !important;
                height: 100% !important;
                background: rgba(0,0,0,0.95) !important;
                z-index: 999999 !important;
                display: flex !important;
                align-items: center !important;
                justify-content: center !important;
                visibility: visible !important;
                opacity: 1 !important;
            `;
            
            modal.innerHTML = `
                <div style="
                    background: linear-gradient(135deg, rgba(0,0,0,0.95), rgba(20,20,40,0.98)) !important;
                    border: 3px solid rgba(144, 238, 144, 0.6) !important;
                    border-radius: 20px !important;
                    padding: 40px !important;
                    max-width: 700px !important;
                    width: 90% !important;
                    max-height: 80vh !important;
                    overflow-y: auto !important;
                    box-shadow: 0 0 50px rgba(144, 238, 144, 0.3) !important;
                    position: relative !important;
                    z-index: 1000000 !important;
                ">
                    <h2 style="color: #90ee90 !important; margin-bottom: 25px !important; font-size: 24px !important; text-align: center !important;">${title}</h2>
                    ${content}
                    <div style="text-align: center; margin-top: 30px;">
                        <button onclick="this.closest('.modal-overlay').remove()" style="
                            background: linear-gradient(135deg, rgba(144, 238, 144, 0.3), rgba(144, 238, 144, 0.5)) !important;
                            border: 2px solid rgba(144, 238, 144, 0.7) !important;
                            color: #90ee90 !important;
                            padding: 15px 30px !important;
                            border-radius: 25px !important;
                            cursor: pointer !important;
                            font-size: 16px !important;
                            font-weight: bold !important;
                            margin-right: 15px !important;
                        ">Fechar</button>
                        <button onclick="
                            const email = 'lucasdeandrade0077@gmail.com';
                            const subject = 'Solicitação de Guia Completo - ${title}';
                            const body = 'Olá! Gostaria de receber o guia completo sobre: ${title}\\n\\nDetalhes:\\n- Tipo: ${guideType}\\n- Página: ${window.location.href}\\n\\nPor favor, envie o guia completo com mais detalhes e exemplos práticos.\\n\\nObrigado!';
                            window.open('mailto:' + email + '?subject=' + encodeURIComponent(subject) + '&body=' + encodeURIComponent(body));
                        " style="
                            background: linear-gradient(135deg, rgba(255, 165, 0, 0.3), rgba(255, 165, 0, 0.5)) !important;
                            border: 2px solid rgba(255, 165, 0, 0.7) !important;
                            color: #ffa500 !important;
                            padding: 15px 30px !important;
                            border-radius: 25px !important;
                            cursor: pointer !important;
                            font-size: 16px !important;
                            font-weight: bold !important;
                        ">📧 Solicitar Guia Completo</button>
                    </div>
                </div>
            `;
            
            document.body.appendChild(modal);
            console.log('✅ Modal de guia criado:', modal);
        }
        
        // Configurar botões "Ler Guia" quando a página carregar
        document.addEventListener('DOMContentLoaded', function() {
            console.log('🔍 Configurando botões "Ler Guia"...');
            
            // Aguardar um pouco para garantir que todos os elementos estão carregados
            setTimeout(function() {
                const guideButtons = document.querySelectorAll('button, a');
                console.log('🔍 Botões encontrados:', guideButtons.length);
                
                guideButtons.forEach(function(btn) {
                    const text = btn.textContent.toLowerCase();
                    if (text.includes('ler guia') || text.includes('guia')) {
                        console.log('🎯 Botão de guia encontrado:', btn.textContent);
                        
                        btn.addEventListener('click', function(e) {
                            e.preventDefault();
                            e.stopPropagation();
                            
                            console.log('🎯 Botão de guia clicado:', btn.textContent);
                            showGuideModal(btn.textContent, btn);
                        });
                    }
                });
            }, 1000);
        });
    </script>
    <script src="<?php echo asset('js/modals.js'); ?>" defer></script>
    <script src="<?php echo asset('script.js'); ?>" defer></script>
</body>
</html>
