<?php
// Script simples para criar as páginas

$pages = [
    'privacidade.php' => '<?php
require_once "../domain-config.php";
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Privacidade Digital | CyberNews</title>
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-JBDJ3PPN93"></script>
    <script>
      window.dataLayer = window.dataLayer || [];
      function gtag(){dataLayer.push(arguments);}
      gtag("js", new Date());
      gtag("config", "G-JBDJ3PPN93");
    </script>
    <link rel="stylesheet" href="<?php echo asset("styles.css"); ?>">
</head>
<body>
    <div id="main-content">
        <header><div class="container"><div class="logo"><h1>CyberNews</h1></div></div></header>
        <main><section class="hero-section"><div class="container"><h1>Privacidade Digital</h1></div></section></main>
        <footer><div class="container"><p>&copy; 2024 CyberNews</p></div></footer>
    </div>
    <script src="<?php echo asset("script.js"); ?>" defer></script>
</body>
</html>',

    'malware.php' => '<?php
require_once "../domain-config.php";
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Malware e Ameaças | CyberNews</title>
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-JBDJ3PPN93"></script>
    <script>
      window.dataLayer = window.dataLayer || [];
      function gtag(){dataLayer.push(arguments);}
      gtag("js", new Date());
      gtag("config", "G-JBDJ3PPN93");
    </script>
    <link rel="stylesheet" href="<?php echo asset("styles.css"); ?>">
</head>
<body>
    <div id="main-content">
        <header><div class="container"><div class="logo"><h1>CyberNews</h1></div></div></header>
        <main><section class="hero-section"><div class="container"><h1>Malware e Ameaças</h1></div></section></main>
        <footer><div class="container"><p>&copy; 2024 CyberNews</p></div></footer>
    </div>
    <script src="<?php echo asset("script.js"); ?>" defer></script>
</body>
</html>',

    'vulnerabilidades.php' => '<?php
require_once "../domain-config.php";
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Vulnerabilidades | CyberNews</title>
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-JBDJ3PPN93"></script>
    <script>
      window.dataLayer = window.dataLayer || [];
      function gtag(){dataLayer.push(arguments);}
      gtag("js", new Date());
      gtag("config", "G-JBDJ3PPN93");
    </script>
    <link rel="stylesheet" href="<?php echo asset("styles.css"); ?>">
</head>
<body>
    <div id="main-content">
        <header><div class="container"><div class="logo"><h1>CyberNews</h1></div></div></header>
        <main><section class="hero-section"><div class="container"><h1>Vulnerabilidades</h1></div></section></main>
        <footer><div class="container"><p>&copy; 2024 CyberNews</p></div></footer>
    </div>
    <script src="<?php echo asset("script.js"); ?>" defer></script>
</body>
</html>'
];

// Criar diretório se não existir
if (!is_dir('acesso_restrito')) {
    mkdir('acesso_restrito', 0755, true);
}

// Criar as páginas
foreach ($pages as $filename => $content) {
    $full_path = 'acesso_restrito/' . $filename;
    if (file_put_contents($full_path, $content)) {
        echo "✅ Criado: $full_path<br>";
    } else {
        echo "❌ Erro: $full_path<br>";
    }
}

echo "<br>🎉 Páginas criadas com sucesso!";
?>
