<?php
header('Content-Type: text/html; charset=utf-8');
date_default_timezone_set('America/Sao_Paulo');
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Vulnerabilidades | CyberNews</title>
    <meta name="description" content="Últimas vulnerabilidades descobertas, CVEs, exploits e patches de segurança. Mantenha-se atualizado sobre falhas de segurança críticas.">
    <meta name="robots" content="index,follow">
    <link rel="canonical" href="<?php echo url('vulnerabilidades'); ?>">

    <!-- Open Graph -->
    <meta property="og:title" content="Vulnerabilidades - CyberNews">
    <meta property="og:description" content="Acompanhe as últimas vulnerabilidades e patches de segurança.">
    <meta property="og:type" content="website">
    <meta property="og:url" content="/vulnerabilidades">
    <meta property="og:site_name" content="CyberNews">

    <link rel="stylesheet" href="<?php echo asset('styles.css'); ?>">
    <link rel="stylesheet" href="<?php echo asset('css/news-psychedelic.css'); ?>">
    <link rel="stylesheet" href="<?php echo asset('css/sections.css'); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
    
    <!-- Google Analytics -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-JBDJ3PPN93"></script>
    <script>
      window.dataLayer = window.dataLayer || [];
      function gtag(){dataLayer.push(arguments);}
      gtag('js', new Date());
      gtag('config', 'G-JBDJ3PPN93');
    </script>
</head>
<body class="psychedelic-mode">
    <!-- Preloader -->
    <div id="preloader">
        <div class="circuit-lines"></div>
        <div class="binary-text"></div>
        <div class="scan-line"></div>
        <div class="preloader-content">
            <div class="holo-container">
                <div class="rotating-ring"></div>
                <div class="rotating-ring"></div>
                <div class="rotating-ring"></div>
                <div class="tech-circle"></div>
                <div class="hex-spinner">
                    <div class="hex"></div>
                    <div class="hex"></div>
                    <div class="hex"></div>
                    <div class="hex"></div>
                    <div class="hex"></div>
                    <div class="hex"></div>
                </div>
                <div class="loading-bubbles">
                    <div class="bubble psychedelic"></div>
                    <div class="bubble psychedelic"></div>
                    <div class="bubble psychedelic"></div>
                    <div class="bubble psychedelic"></div>
                    <div class="bubble psychedelic"></div>
                    <div class="bubble psychedelic"></div>
                </div>
                <div class="neon-text">
                    <span class="glitch-text" data-text="VULNERABILIDADES">VULNERABILIDADES</span>
                    <div class="loading-dots">
                        <span></span><span></span><span></span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Botão Voltar ao Topo -->
    <div class="back-to-top">
        <i class="fas fa-arrow-up"></i>
    </div>

    <!-- Menu Lateral -->
    <div class="psychedelic-menu-container">
        <div class="menu-toggle">
            <div class="hamburger">
                <span></span>
                <span></span>
                <span></span>
            </div>
        </div>
        
        <nav class="side-menu">
            <div class="menu-background">
                <div class="liquid-shape"></div>
                <div class="fractal-pattern"></div>
                <div class="glow-particles"></div>
            </div>
            
            <div class="menu-content">
                <div class="menu-header">
                    <div class="menu-logo">
                        <h2>CyberNews</h2>
                    </div>
                </div>
                
                <ul class="menu-items">
                    <li class="menu-item">
                        <a href="<?php echo url(''); ?>" class="menu-link">
                            <i class="fas fa-home"></i>
                            <span>Início</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                    <li class="menu-item">
                        <a href="<?php echo url('noticias'); ?>" class="menu-link">
                            <i class="fas fa-newspaper"></i>
                            <span>Notícias</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                    <li class="menu-item">
                        <a href="<?php echo url('seguranca'); ?>" class="menu-link">
                            <i class="fas fa-lock"></i>
                            <span>Segurança</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                    <li class="menu-item active">
                        <a href="<?php echo url('vulnerabilidades'); ?>" class="menu-link">
                            <i class="fas fa-bug"></i>
                            <span>Vulnerabilidades</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                    <li class="menu-item">
                        <a href="<?php echo url('malware'); ?>" class="menu-link">
                            <i class="fas fa-virus"></i>
                            <span>Malware</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                    <li class="menu-item">
                        <a href="<?php echo url('privacidade'); ?>" class="menu-link">
                            <i class="fas fa-user-secret"></i>
                            <span>Privacidade</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                    <li class="menu-item">
                        <a href="<?php echo url('loja'); ?>" class="menu-link" aria-label="Loja">
                            <i class="fas fa-shopping-cart" aria-hidden="true"></i>
                            <span>Loja</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                    <li class="menu-item">
                        <a href="https://lucas.br.vc/" class="menu-link" target="_blank" aria-label="Contato">
                            <i class="fas fa-envelope" aria-hidden="true"></i>
                            <span>Contato</span>
                            <div class="link-fx"></div>
                        </a>
                    </li>
                </ul>
                
                <div class="menu-footer">
                    <div class="social-icons">
                        <a href="#" class="social-icon"><i class="fab fa-twitter"></i></a>
                        <a href="#" class="social-icon"><i class="fab fa-github"></i></a>
                        <a href="#" class="social-icon"><i class="fab fa-linkedin"></i></a>
                    </div>
                    <div class="admin-menu-access">
                        <a href="<?php echo url('admin/'); ?>" class="admin-menu-btn" title="Painel Admin">
                            <i class="fas fa-cogs"></i>
                        </a>
                    </div>
                </div>
            </div>
        </nav>
    </div>

    <header>
        <div class="container" role="banner">
            <div class="logo" aria-label="CyberNews Logo">
                <h1 style="margin:0;">CyberNews</h1>
            </div>
            <nav aria-label="Navegação principal">
                <a href="<?php echo url(''); ?>" class="admin-btn" style="text-decoration:none;">
                    <i class="fas fa-home" aria-hidden="true"></i> Início
                </a>
            </nav>
        </div>
    </header>

    <main class="main-content" role="main">
        <div id="main-content">
            <div class="container">
                <section class="store-hero" aria-labelledby="vuln-title">
                    <h1 id="vuln-title">🐛 Vulnerabilidades</h1>
                    <p>Acompanhe as últimas vulnerabilidades descobertas, CVEs críticas e patches de segurança.</p>
                </section>

                <!-- Dashboard de Vulnerabilidades Críticas -->
                <section class="critical-vulnerabilities" aria-label="Vulnerabilidades Críticas">
                    <div class="section-header">
                        <h2>🚨 Alertas Críticos</h2>
                        <p>Vulnerabilidades de alta severidade que requerem ação imediata</p>
                    </div>
                    
                    <div class="vuln-dashboard">
                        <div class="vuln-stats">
                            <div class="stat-card critical">
                                <div class="stat-icon">
                                    <i class="fas fa-exclamation-triangle"></i>
                                </div>
                                <div class="stat-content">
                                    <h3>23</h3>
                                    <p>CVEs Críticas<br><small>Últimos 30 dias</small></p>
                                </div>
                            </div>
                            <div class="stat-card high">
                                <div class="stat-icon">
                                    <i class="fas fa-shield-alt"></i>
                                </div>
                                <div class="stat-content">
                                    <h3>156</h3>
                                    <p>Patches Disponíveis<br><small>Aguardando aplicação</small></p>
                                </div>
                            </div>
                            <div class="stat-card medium">
                                <div class="stat-icon">
                                    <i class="fas fa-bug"></i>
                                </div>
                                <div class="stat-content">
                                    <h3>892</h3>
                                    <p>Zero-Days<br><small>Descobertos em 2024</small></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>

                <!-- Lista de CVEs Recentes -->
                <section class="recent-cves" aria-label="CVEs Recentes">
                    <div class="section-header">
                        <h2>📋 CVEs Recentes</h2>
                        <p>Vulnerabilidades mais recentes catalogadas no sistema CVE</p>
                    </div>
                    
                    <div class="cve-list">
                        <!-- CVE 1 -->
                        <article class="cve-card critical">
                            <div class="cve-header">
                                <div class="cve-id">CVE-2024-8234</div>
                                <div class="severity-badge critical">CRÍTICA 9.8</div>
                            </div>
                            <h3>Execução Remota de Código no Apache HTTP Server</h3>
                            <p>Vulnerabilidade permite execução arbitrária de código através de requisições HTTP malformadas em versões 2.4.0 a 2.4.58.</p>
                            <div class="cve-details">
                                <div class="detail-item">
                                    <strong>Produto:</strong> Apache HTTP Server
                                </div>
                                <div class="detail-item">
                                    <strong>Versões Afetadas:</strong> 2.4.0 - 2.4.58
                                </div>
                                <div class="detail-item">
                                    <strong>Patch:</strong> <span class="status available">Disponível (v2.4.59)</span>
                                </div>
                                <div class="detail-item">
                                    <strong>Exploits:</strong> <span class="status public">Públicos disponíveis</span>
                                </div>
                            </div>
                            <div class="cve-actions">
                                <a href="#" class="cve-btn primary">Ver Detalhes</a>
                                <a href="#" class="cve-btn">Download Patch</a>
                                <a href="#" class="cve-btn">PoC/Exploit</a>
                            </div>
                        </article>

                        <!-- CVE 2 -->
                        <article class="cve-card high">
                            <div class="cve-header">
                                <div class="cve-id">CVE-2024-8156</div>
                                <div class="severity-badge high">ALTA 8.1</div>
                            </div>
                            <h3>Bypass de Autenticação no Microsoft Exchange</h3>
                            <p>Falha de validação permite bypass de autenticação em servidores Exchange, possibilitando acesso não autorizado a emails.</p>
                            <div class="cve-details">
                                <div class="detail-item">
                                    <strong>Produto:</strong> Microsoft Exchange Server
                                </div>
                                <div class="detail-item">
                                    <strong>Versões Afetadas:</strong> 2016, 2019, 2022
                                </div>
                                <div class="detail-item">
                                    <strong>Patch:</strong> <span class="status available">Disponível (MS-24-09)</span>
                                </div>
                                <div class="detail-item">
                                    <strong>Exploits:</strong> <span class="status limited">Exploração limitada</span>
                                </div>
                            </div>
                            <div class="cve-actions">
                                <a href="#" class="cve-btn primary">Ver Detalhes</a>
                                <a href="#" class="cve-btn">Download Patch</a>
                                <a href="#" class="cve-btn">Mitigações</a>
                            </div>
                        </article>

                        <!-- CVE 3 -->
                        <article class="cve-card medium">
                            <div class="cve-header">
                                <div class="cve-id">CVE-2024-8089</div>
                                <div class="severity-badge medium">MÉDIA 6.5</div>
                            </div>
                            <h3>Injeção SQL no WordPress Plugin WooCommerce</h3>
                            <p>Vulnerabilidade de injeção SQL permite extração de dados do banco através de parâmetros não sanitizados.</p>
                            <div class="cve-details">
                                <div class="detail-item">
                                    <strong>Produto:</strong> WooCommerce Plugin
                                </div>
                                <div class="detail-item">
                                    <strong>Versões Afetadas:</strong> 8.0.0 - 8.2.1
                                </div>
                                <div class="detail-item">
                                    <strong>Patch:</strong> <span class="status available">Disponível (v8.2.2)</span>
                                </div>
                                <div class="detail-item">
                                    <strong>Exploits:</strong> <span class="status none">Não conhecidos</span>
                                </div>
                            </div>
                            <div class="cve-actions">
                                <a href="#" class="cve-btn primary">Ver Detalhes</a>
                                <a href="#" class="cve-btn">Atualizar Plugin</a>
                                <a href="#" class="cve-btn">WAF Rules</a>
                            </div>
                        </article>
                    </div>
                </section>

                <!-- Seção de Ferramentas de Análise -->
                <section class="vuln-tools" aria-label="Ferramentas de Análise">
                    <div class="section-header">
                        <h2>🛠️ Ferramentas de Análise</h2>
                        <p>Scanners e ferramentas para identificar vulnerabilidades</p>
                    </div>
                    
                    <div class="tools-grid">
                        <div class="tool-category">
                            <h3>🔍 Scanners de Vulnerabilidades</h3>
                            <div class="tool-list">
                                <div class="tool-item">
                                    <div class="tool-header">
                                        <strong>Nessus Professional</strong>
                                        <span class="tool-type commercial">COMERCIAL</span>
                                    </div>
                                    <p>Scanner profissional com banco de dados extenso de vulnerabilidades</p>
                                    <div class="tool-features">
                                        <span>✅ 100,000+ plugins</span>
                                        <span>✅ Compliance scanning</span>
                                        <span>✅ Web app testing</span>
                                    </div>
                                    <a href="#" class="tool-link">Experimentar</a>
                                </div>
                                
                                <div class="tool-item">
                                    <div class="tool-header">
                                        <strong>OpenVAS</strong>
                                        <span class="tool-type free">GRATUITO</span>
                                    </div>
                                    <p>Scanner open-source com atualizações regulares de feeds</p>
                                    <div class="tool-features">
                                        <span>✅ Open source</span>
                                        <span>✅ Network scanning</span>
                                        <span>✅ Reporting</span>
                                    </div>
                                    <a href="#" class="tool-link">Download</a>
                                </div>

                                <div class="tool-item">
                                    <div class="tool-header">
                                        <strong>Nuclei</strong>
                                        <span class="tool-type free">GRATUITO</span>
                                    </div>
                                    <p>Scanner rápido baseado em templates YAML</p>
                                    <div class="tool-features">
                                        <span>✅ Template-based</span>
                                        <span>✅ Fast scanning</span>
                                        <span>✅ Community driven</span>
                                    </div>
                                    <a href="#" class="tool-link">GitHub</a>
                                </div>
                            </div>
                        </div>

                        <div class="tool-category">
                            <h3>🌐 Web Application Testing</h3>
                            <div class="tool-list">
                                <div class="tool-item">
                                    <div class="tool-header">
                                        <strong>Burp Suite Professional</strong>
                                        <span class="tool-type commercial">COMERCIAL</span>
                                    </div>
                                    <p>Plataforma completa para teste de segurança em aplicações web</p>
                                    <div class="tool-features">
                                        <span>✅ Proxy interception</span>
                                        <span>✅ Active scanning</span>
                                        <span>✅ Extensive plugins</span>
                                    </div>
                                    <a href="#" class="tool-link">Experimentar</a>
                                </div>

                                <div class="tool-item">
                                    <div class="tool-header">
                                        <strong>OWASP ZAP</strong>
                                        <span class="tool-type free">GRATUITO</span>
                                    </div>
                                    <p>Proxy de segurança para encontrar vulnerabilidades em aplicações web</p>
                                    <div class="tool-features">
                                        <span>✅ OWASP project</span>
                                        <span>✅ API testing</span>
                                        <span>✅ Automation</span>
                                    </div>
                                    <a href="#" class="tool-link">Download</a>
                                </div>

                                <div class="tool-item">
                                    <div class="tool-header">
                                        <strong>Nikto</strong>
                                        <span class="tool-type free">GRATUITO</span>
                                    </div>
                                    <p>Scanner de vulnerabilidades específico para servidores web</p>
                                    <div class="tool-features">
                                        <span>✅ Web server focus</span>
                                        <span>✅ Plugin system</span>
                                        <span>✅ SSL support</span>
                                    </div>
                                    <a href="#" class="tool-link">Download</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>

                <!-- Seção de Recursos Educacionais -->
                <section class="vuln-education" aria-label="Recursos Educacionais">
                    <div class="section-header">
                        <h2>📚 Recursos Educacionais</h2>
                        <p>Aprenda sobre identificação e correção de vulnerabilidades</p>
                    </div>
                    
                    <div class="education-grid">
                        <article class="education-card">
                            <div class="education-icon">
                                <i class="fas fa-graduation-cap"></i>
                            </div>
                            <h3>Metodologias de Teste</h3>
                            <p>Aprenda as principais metodologias de teste de penetração</p>
                            <ul>
                                <li>• OWASP Testing Guide</li>
                                <li>• PTES (Penetration Testing Execution Standard)</li>
                                <li>• NIST Cybersecurity Framework</li>
                                <li>• OSSTMM (Open Source Security Testing)</li>
                            </ul>
                            <a href="#" class="education-btn">📖 Estudar</a>
                        </article>

                        <article class="education-card">
                            <div class="education-icon">
                                <i class="fas fa-code"></i>
                            </div>
                            <h3>Laboratórios Práticos</h3>
                            <p>Ambientes seguros para praticar identificação de vulnerabilidades</p>
                            <ul>
                                <li>• DVWA (Damn Vulnerable Web Application)</li>
                                <li>• WebGoat (OWASP)</li>
                                <li>• Metasploitable</li>
                                <li>• VulnHub VMs</li>
                            </ul>
                            <a href="#" class="education-btn">🧪 Praticar</a>
                        </article>

                        <article class="education-card">
                            <div class="education-icon">
                                <i class="fas fa-certificate"></i>
                            </div>
                            <h3>Certificações</h3>
                            <p>Certificações reconhecidas na área de segurança</p>
                            <ul>
                                <li>• CEH (Certified Ethical Hacker)</li>
                                <li>• OSCP (Offensive Security Certified Professional)</li>
                                <li>• CISSP (Certified Information Systems Security Professional)</li>
                                <li>• GCIH (GIAC Certified Incident Handler)</li>
                            </ul>
                            <a href="#" class="education-btn">🏆 Certificar</a>
                        </article>
                    </div>
                </section>

                <!-- Feed de Vulnerabilidades em Tempo Real -->
                <section class="vuln-feed" aria-label="Feed de Vulnerabilidades">
                    <div class="section-header">
                        <h2>📡 Feed em Tempo Real</h2>
                        <p>Últimas vulnerabilidades descobertas e divulgadas</p>
                    </div>
                    
                    <div class="feed-container">
                        <div class="feed-item">
                            <div class="feed-time">Há 2 horas</div>
                            <div class="feed-content">
                                <strong>Nova vulnerabilidade zero-day</strong> descoberta no kernel Linux afetando sistemas de containers
                            </div>
                            <div class="feed-severity critical">CRÍTICA</div>
                        </div>
                        
                        <div class="feed-item">
                            <div class="feed-time">Há 4 horas</div>
                            <div class="feed-content">
                                <strong>Microsoft lança patch</strong> para vulnerabilidade de escalação de privilégios no Windows 11
                            </div>
                            <div class="feed-severity high">ALTA</div>
                        </div>
                        
                        <div class="feed-item">
                            <div class="feed-time">Há 6 horas</div>
                            <div class="feed-content">
                                <strong>Chrome 118 corrige</strong> 15 vulnerabilidades de segurança, incluindo 3 críticas
                            </div>
                            <div class="feed-severity medium">MÉDIA</div>
                        </div>
                        
                        <div class="feed-item">
                            <div class="feed-time">Há 8 horas</div>
                            <div class="feed-content">
                                <strong>Exploit público disponível</strong> para vulnerabilidade RCE no Apache Struts
                            </div>
                            <div class="feed-severity critical">CRÍTICA</div>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </main>

    <footer>
        <div class="container">
            <div class="footer-content">
                <div class="footer-logo">
                    <h2>CyberNews</h2>
                </div>
                <p>Mantenha-se informado sobre as últimas vulnerabilidades.</p>
            </div>
            <div class="copyright">
                <p>&copy; <?= date('Y') ?> CyberNews - Todos os direitos reservados.</p>
            </div>
        </div>
    </footer>
    
    <script src="<?php echo asset('js/performance.js'); ?>" defer></script>
    <script>
        // Função para criar modal de guia
        function showGuideModal(guideType, btn) {
            console.log('🧠 showGuideModal chamada:', guideType, btn);
            
            // Remover modal anterior se existir
            const existingModal = document.querySelector('.modal-overlay');
            if (existingModal) {
                existingModal.remove();
            }
            
            // Conteúdo baseado no tipo de guia
            let content = '';
            let title = '';
            
            if (guideType.includes('vulnerabilidade') || guideType.includes('vuln')) {
                title = '🐛 Guia de Vulnerabilidades';
                content = `
                    <div style="text-align: left; color: #b9f9b9; line-height: 1.6;">
                        <h3 style="color: #90ee90; margin-bottom: 15px;">🔍 Identificação de Vulnerabilidades</h3>
                        <ul style="margin-bottom: 20px;">
                            <li>✅ Use scanners automatizados</li>
                            <li>✅ Monitore CVE databases</li>
                            <li>✅ Faça testes de penetração</li>
                            <li>✅ Analise logs de segurança</li>
                            <li>✅ Implemente detecção de anomalias</li>
                        </ul>
                        <h3 style="color: #90ee90; margin-bottom: 15px;">🛡️ Correção e Mitigação</h3>
                        <ul>
                            <li>🔧 Aplique patches rapidamente</li>
                            <li>🔄 Implemente workarounds temporários</li>
                            <li>📊 Priorize por criticidade</li>
                        </ul>
                    </div>
                `;
            } else if (guideType.includes('patch') || guideType.includes('atualização')) {
                title = '🔧 Guia de Patches e Atualizações';
                content = `
                    <div style="text-align: left; color: #b9f9b9; line-height: 1.6;">
                        <h3 style="color: #90ee90; margin-bottom: 15px;">🔧 Gerenciamento de Patches</h3>
                        <ul style="margin-bottom: 20px;">
                            <li>✅ Teste patches em ambiente de desenvolvimento</li>
                            <li>✅ Faça backup antes de aplicar</li>
                            <li>✅ Aplique patches críticos imediatamente</li>
                            <li>✅ Documente todas as mudanças</li>
                            <li>✅ Monitore após aplicação</li>
                        </ul>
                        <h3 style="color: #90ee90; margin-bottom: 15px;">📋 Processo de Atualização</h3>
                        <ul>
                            <li>📅 Agende janelas de manutenção</li>
                            <li>🔄 Use automação quando possível</li>
                            <li>📊 Mantenha inventário atualizado</li>
                        </ul>
                    </div>
                `;
            } else {
                title = '🛡️ Guia de Segurança de Vulnerabilidades';
                content = `
                    <div style="text-align: left; color: #b9f9b9; line-height: 1.6;">
                        <h3 style="color: #90ee90; margin-bottom: 15px;">🔍 Monitoramento Contínuo</h3>
                        <ul style="margin-bottom: 20px;">
                            <li>✅ Configure alertas automáticos</li>
                            <li>✅ Monitore feeds de segurança</li>
                            <li>✅ Faça varreduras regulares</li>
                            <li>✅ Analise relatórios de vulnerabilidade</li>
                            <li>✅ Mantenha inventário de ativos</li>
                        </ul>
                        <h3 style="color: #90ee90; margin-bottom: 15px;">🚨 Resposta a Incidentes</h3>
                        <ul>
                            <li>📋 Tenha plano de resposta definido</li>
                            <li>⚡ Aja rapidamente em vulnerabilidades críticas</li>
                            <li>📞 Comunique stakeholders relevantes</li>
                        </ul>
                    </div>
                `;
            }
            
            const modal = document.createElement('div');
            modal.className = 'modal-overlay';
            modal.style.cssText = `
                position: fixed !important;
                top: 0 !important;
                left: 0 !important;
                width: 100% !important;
                height: 100% !important;
                background: rgba(0,0,0,0.95) !important;
                z-index: 999999 !important;
                display: flex !important;
                align-items: center !important;
                justify-content: center !important;
                visibility: visible !important;
                opacity: 1 !important;
            `;
            
            modal.innerHTML = `
                <div style="
                    background: linear-gradient(135deg, rgba(0,0,0,0.95), rgba(20,20,40,0.98)) !important;
                    border: 3px solid rgba(144, 238, 144, 0.6) !important;
                    border-radius: 20px !important;
                    padding: 40px !important;
                    max-width: 700px !important;
                    width: 90% !important;
                    max-height: 80vh !important;
                    overflow-y: auto !important;
                    box-shadow: 0 0 50px rgba(144, 238, 144, 0.3) !important;
                    position: relative !important;
                    z-index: 1000000 !important;
                ">
                    <h2 style="color: #90ee90 !important; margin-bottom: 25px !important; font-size: 24px !important; text-align: center !important;">${title}</h2>
                    ${content}
                    <div style="text-align: center; margin-top: 30px;">
                        <button onclick="this.closest('.modal-overlay').remove()" style="
                            background: linear-gradient(135deg, rgba(144, 238, 144, 0.3), rgba(144, 238, 144, 0.5)) !important;
                            border: 2px solid rgba(144, 238, 144, 0.7) !important;
                            color: #90ee90 !important;
                            padding: 15px 30px !important;
                            border-radius: 25px !important;
                            cursor: pointer !important;
                            font-size: 16px !important;
                            font-weight: bold !important;
                            margin-right: 15px !important;
                        ">Fechar</button>
                        <button onclick="
                            const email = 'lucasdeandrade0077@gmail.com';
                            const subject = 'Solicitação de Guia Completo - ${title}';
                            const body = 'Olá! Gostaria de receber o guia completo sobre: ${title}\\n\\nDetalhes:\\n- Tipo: ${guideType}\\n- Página: ${window.location.href}\\n\\nPor favor, envie o guia completo com mais detalhes e exemplos práticos.\\n\\nObrigado!';
                            window.open('mailto:' + email + '?subject=' + encodeURIComponent(subject) + '&body=' + encodeURIComponent(body));
                        " style="
                            background: linear-gradient(135deg, rgba(255, 165, 0, 0.3), rgba(255, 165, 0, 0.5)) !important;
                            border: 2px solid rgba(255, 165, 0, 0.7) !important;
                            color: #ffa500 !important;
                            padding: 15px 30px !important;
                            border-radius: 25px !important;
                            cursor: pointer !important;
                            font-size: 16px !important;
                            font-weight: bold !important;
                        ">📧 Solicitar Guia Completo</button>
                    </div>
                </div>
            `;
            
            document.body.appendChild(modal);
            console.log('✅ Modal de guia criado:', modal);
        }
        
        // Configurar botões "Ler Guia" quando a página carregar
        document.addEventListener('DOMContentLoaded', function() {
            console.log('🔍 Configurando botões "Ler Guia"...');
            
            // Aguardar um pouco para garantir que todos os elementos estão carregados
            setTimeout(function() {
                const guideButtons = document.querySelectorAll('button, a');
                console.log('🔍 Botões encontrados:', guideButtons.length);
                
                guideButtons.forEach(function(btn) {
                    const text = btn.textContent.toLowerCase();
                    if (text.includes('ler guia') || text.includes('guia')) {
                        console.log('🎯 Botão de guia encontrado:', btn.textContent);
                        
                        btn.addEventListener('click', function(e) {
                            e.preventDefault();
                            e.stopPropagation();
                            
                            console.log('🎯 Botão de guia clicado:', btn.textContent);
                            showGuideModal(btn.textContent, btn);
                        });
                    }
                });
            }, 1000);
        });
    </script>
    <script src="<?php echo asset('js/modals.js'); ?>" defer></script>
    <script src="<?php echo asset('script.js'); ?>" defer></script>
</body>
</html>
